/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.draw;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.type.draw.OdfType;
import org.odftoolkit.odfdom.dom.type.OdfLength;
import org.odftoolkit.odfdom.dom.type.OdfId;
import org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;

import org.odftoolkit.odfdom.dom.element.svg.OdfTitleElement;
import org.odftoolkit.odfdom.dom.element.svg.OdfDescElement;
import org.odftoolkit.odfdom.dom.element.office.OdfEventListenersElement;
import org.odftoolkit.odfdom.dom.type.draw.OdfEscapeDirectionType;
import org.odftoolkit.odfdom.dom.element.text.OdfParagraphElement;
import org.odftoolkit.odfdom.dom.element.text.OdfListElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink draw:connector}.
 *
 */
public abstract class OdfConnectorElement extends OdfShapeElementBase
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DRAW, "connector" );

    /**
     * Create the instance of OdfConnectorElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfConnectorElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink draw:connector}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfConnectorElement}
     *
     *@param viewBox  The mandatory attribute {@attributeName  svg:viewBox}" 
     *
     */
    public void init(Integer viewBox)
    {
        setViewBox( viewBox );
    }

    /**
     * Get value of attribute {@attributeName draw:type}.
     *
     *@return return the attribute which type is OdfType
     */
    public OdfType getType()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "type" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "standard";
        }

        return OdfType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:type}.
     *
     *@param  type    the attribute's type is OdfType
     */ 
     public void setType( OdfType type )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "type" ), type.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:x1}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getX1()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "x1" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:x1}.
     *
     *@param  x1    the attribute's type is OdfLength
     */ 
     public void setX1( OdfLength x1 )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "x1" ), x1.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:y1}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getY1()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "y1" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:y1}.
     *
     *@param  y1    the attribute's type is OdfLength
     */ 
     public void setY1( OdfLength y1 )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "y1" ), y1.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:start-shape}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getStartShape()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "start-shape" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:start-shape}.
     *
     *@param  startShape    the attribute's type is OdfId
     */ 
     public void setStartShape( OdfId startShape )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "start-shape" ), startShape.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:start-glue-point}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getStartGluePoint()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "start-glue-point" ) );
        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:start-glue-point}.
     *
     *@param  startGluePoint    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setStartGluePoint( OdfNonNegativeInteger startGluePoint )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "start-glue-point" ), startGluePoint.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:x2}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getX2()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "x2" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:x2}.
     *
     *@param  x2    the attribute's type is OdfLength
     */ 
     public void setX2( OdfLength x2 )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "x2" ), x2.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:y2}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getY2()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "y2" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:y2}.
     *
     *@param  y2    the attribute's type is OdfLength
     */ 
     public void setY2( OdfLength y2 )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "y2" ), y2.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:end-shape}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getEndShape()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "end-shape" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:end-shape}.
     *
     *@param  endShape    the attribute's type is OdfId
     */ 
     public void setEndShape( OdfId endShape )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "end-shape" ), endShape.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:end-glue-point}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getEndGluePoint()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "end-glue-point" ) );
        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:end-glue-point}.
     *
     *@param  endGluePoint    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setEndGluePoint( OdfNonNegativeInteger endGluePoint )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "end-glue-point" ), endGluePoint.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:line-skew}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getLineSkew()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "line-skew" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:line-skew}.
     *
     *@param  lineSkew    the attribute's type is OdfLength
     */ 
     public void setLineSkew( OdfLength lineSkew )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "line-skew" ), lineSkew.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:d}.
     *
     *@return return the attribute which type is String
     */
    public String getD()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.SVG, "d" ) );
    }

    /**
     * Set value of attribute {@attributeName svg:d}.
     *
     *@param  d    the attribute's type is String
     */ 
     public void setD( String d )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "d" ), d );
    }

    /**
     * Get value of attribute {@attributeName draw:layer}.
     *
     *@return return the attribute which type is String
     */
    public String getLayer()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "layer" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:layer}.
     *
     *@param  layer    the attribute's type is String
     */ 
     public void setLayer( String layer )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "layer" ), layer );
    }

    /**
     * Get value of attribute {@attributeName draw:transform}.
     *
     *@return return the attribute which type is String
     */
    public String getTransform()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "transform" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:transform}.
     *
     *@param  transform    the attribute's type is String
     */ 
     public void setTransform( String transform )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "transform" ), transform );
    }

    /**
     * Get value of attribute {@attributeName draw:text-style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getTextStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "text-style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:text-style-name}.
     *
     *@param  textStyleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setTextStyleName( OdfStyleNameRef textStyleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "text-style-name" ), textStyleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:caption-id}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getCaptionId()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "caption-id" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:caption-id}.
     *
     *@param  captionId    the attribute's type is OdfId
     */ 
     public void setCaptionId( OdfId captionId )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "caption-id" ), captionId.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:viewBox}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getViewBox()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "viewBox" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:viewBox}.
     *
     *@param  viewBox    the attribute's type is Integer
     */ 
     public void setViewBox( Integer viewBox )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "viewBox" ), viewBox.toString() );
    }

    /**
    * Create child element {@odfLink svg:title}.
    *
    *@return   return  the element {@odfLink svg:title}
    */
    public OdfTitleElement createTitleElement()
    {
        OdfTitleElement  nTitle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTitleElement.class);
        this.appendChild( nTitle);
        return  nTitle;
    }                   
               
    /**
    * Create child element {@odfLink svg:desc}.
    *
    *@return   return  the element {@odfLink svg:desc}
    */
    public OdfDescElement createDescElement()
    {
        OdfDescElement  nDesc = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDescElement.class);
        this.appendChild( nDesc);
        return  nDesc;
    }                   
               
    /**
    * Create child element {@odfLink office:event-listeners}.
    *
    *@return   return  the element {@odfLink office:event-listeners}
    */
    public OdfEventListenersElement createEventListenersElement()
    {
        OdfEventListenersElement  nEventListeners = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfEventListenersElement.class);
        this.appendChild( nEventListeners);
        return  nEventListeners;
    }                   
               
    /**
    * Create child element {@odfLink draw:glue-point}.
    *
    *@param drawid  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger
    *@param x  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param y  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param escapeDirection     the attribute's type is OdfEscapeDirectionType, see {@attributeName  draw:escape-direction} at specification
    *@return   return  the element {@odfLink draw:glue-point}
    */
    public OdfGluePointElement createGluePointElement(org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger   drawid, org.odftoolkit.odfdom.dom.type.OdfLength   x, org.odftoolkit.odfdom.dom.type.OdfLength   y, OdfEscapeDirectionType   escapeDirection)
    {
        OdfGluePointElement  nGluePoint = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfGluePointElement.class);
        nGluePoint.setDrawid( drawid);
        nGluePoint.setX( x);
        nGluePoint.setY( y);
        nGluePoint.setEscapeDirection( escapeDirection);
        this.appendChild( nGluePoint);
        return  nGluePoint;      
    }
    
    /**
    * Create child element {@odfLink text:p}.
    *
    *@return   return  the element {@odfLink text:p}
    */
    public OdfParagraphElement createParagraphElement()
    {
        OdfParagraphElement  nParagraph = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfParagraphElement.class);
        this.appendChild( nParagraph);
        return  nParagraph;
    }                   
               
    /**
    * Create child element {@odfLink text:list}.
    *
    *@return   return  the element {@odfLink text:list}
    */
    public OdfListElement createListElement()
    {
        OdfListElement  nList = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfListElement.class);
        this.appendChild( nList);
        return  nList;
    }                   
               
}
