/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.draw;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import java.net.URI;
import org.odftoolkit.odfdom.dom.type.OdfAnyURI;
import org.odftoolkit.odfdom.dom.type.office.OdfTargetFrameNameType;
import org.odftoolkit.odfdom.dom.type.xlink.OdfShowType;
import org.odftoolkit.odfdom.dom.type.OdfLength;

import org.odftoolkit.odfdom.dom.element.svg.OdfTitleElement;
import org.odftoolkit.odfdom.dom.element.svg.OdfDescElement;
import org.odftoolkit.odfdom.dom.element.office.OdfEventListenersElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink draw:area-polygon}.
 *
 */
public abstract class OdfAreaPolygonElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DRAW, "area-polygon" );

    /**
     * Create the instance of OdfAreaPolygonElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfAreaPolygonElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink draw:area-polygon}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfAreaPolygonElement}
     *
     *@param x  The mandatory attribute {@attributeName  svg:x}" 
     *@param y  The mandatory attribute {@attributeName  svg:y}" 
     *@param width  The mandatory attribute {@attributeName  svg:width}" 
     *@param height  The mandatory attribute {@attributeName  svg:height}" 
     *@param viewBox  The mandatory attribute {@attributeName  svg:viewBox}" 
     *@param points  The mandatory attribute {@attributeName  draw:points}" 
     *
     */
    public void init(OdfLength x, OdfLength y, OdfLength width, OdfLength height, Integer viewBox, String points)
    {
        setX( x );
        setY( y );
        setWidth( width );
        setHeight( height );
        setViewBox( viewBox );
        setPoints( points );
    }

    /**
     * Get value of attribute {@attributeName xlink:href}.
     *
     *@return return the attribute which type is OdfAnyURI
     */
    public OdfAnyURI getHref()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XLINK, "href" ) );
        return OdfAnyURI.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xlink:href}.
     *
     *@param  href    the attribute's type is OdfAnyURI
     */ 
     public void setHref( OdfAnyURI href )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "href" ), href.toString() );
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "type" ), "simple" );
    }

    /**
     * Get value of attribute {@attributeName office:target-frame-name}.
     *
     *@return return the attribute which type is OdfTargetFrameNameType
     */
    public OdfTargetFrameNameType getTargetFrameName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "target-frame-name" ) );
        return OdfTargetFrameNameType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName office:target-frame-name}.
     *
     *@param  targetFrameName    the attribute's type is OdfTargetFrameNameType
     */ 
     public void setTargetFrameName( OdfTargetFrameNameType targetFrameName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "target-frame-name" ), targetFrameName.toString() );
    }

    /**
     * Get value of attribute {@attributeName xlink:show}.
     *
     *@return return the attribute which type is OdfShowType
     */
    public OdfShowType getShow()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XLINK, "show" ) );
        return OdfShowType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xlink:show}.
     *
     *@param  show    the attribute's type is OdfShowType
     */ 
     public void setShow( OdfShowType show )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "show" ), show.toString() );
    }

    /**
     * Get value of attribute {@attributeName office:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "name" ) );
    }

    /**
     * Set value of attribute {@attributeName office:name}.
     *
     *@param  name    the attribute's type is String
     */ 
     public void setName( String name )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "name" ), name );
    }

    /**
     * Get value of attribute {@attributeName draw:nohref}.
     *
     *@return return the attribute which type is String
     */
    public String getNohref()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "nohref" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:nohref}.
     *
     *@param  nohref    the attribute's type is String
     */ 
     public void setNohref( String nohref )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "nohref" ), nohref );
    }

    /**
     * Get value of attribute {@attributeName svg:x}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getX()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "x" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:x}.
     *
     *@param  x    the attribute's type is OdfLength
     */ 
     public void setX( OdfLength x )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "x" ), x.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:y}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getY()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "y" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:y}.
     *
     *@param  y    the attribute's type is OdfLength
     */ 
     public void setY( OdfLength y )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "y" ), y.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:width}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getWidth()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "width" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:width}.
     *
     *@param  width    the attribute's type is OdfLength
     */ 
     public void setWidth( OdfLength width )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "width" ), width.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:height}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getHeight()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "height" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:height}.
     *
     *@param  height    the attribute's type is OdfLength
     */ 
     public void setHeight( OdfLength height )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "height" ), height.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:viewBox}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getViewBox()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "viewBox" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:viewBox}.
     *
     *@param  viewBox    the attribute's type is Integer
     */ 
     public void setViewBox( Integer viewBox )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "viewBox" ), viewBox.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:points}.
     *
     *@return return the attribute which type is String
     */
    public String getPoints()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "points" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:points}.
     *
     *@param  points    the attribute's type is String
     */ 
     public void setPoints( String points )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "points" ), points );
    }

    /**
    * Create child element {@odfLink svg:title}.
    *
    *@return   return  the element {@odfLink svg:title}
    */
    public OdfTitleElement createTitleElement()
    {
        OdfTitleElement  nTitle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTitleElement.class);
        this.appendChild( nTitle);
        return  nTitle;
    }                   
               
    /**
    * Create child element {@odfLink svg:desc}.
    *
    *@return   return  the element {@odfLink svg:desc}
    */
    public OdfDescElement createDescElement()
    {
        OdfDescElement  nDesc = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDescElement.class);
        this.appendChild( nDesc);
        return  nDesc;
    }                   
               
    /**
    * Create child element {@odfLink office:event-listeners}.
    *
    *@return   return  the element {@odfLink office:event-listeners}
    */
    public OdfEventListenersElement createEventListenersElement()
    {
        OdfEventListenersElement  nEventListeners = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfEventListenersElement.class);
        this.appendChild( nEventListeners);
        return  nEventListeners;
    }                   
               
}
