/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.draw;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import java.net.URI;
import org.odftoolkit.odfdom.dom.type.OdfAnyURI;
import org.odftoolkit.odfdom.dom.type.office.OdfTargetFrameNameType;
import org.odftoolkit.odfdom.dom.type.xlink.OdfShowType;
import org.odftoolkit.odfdom.dom.type.OdfLength;

import org.odftoolkit.odfdom.dom.element.svg.OdfTitleElement;
import org.odftoolkit.odfdom.dom.element.svg.OdfDescElement;
import org.odftoolkit.odfdom.dom.element.office.OdfEventListenersElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink draw:area-circle}.
 *
 */
public abstract class OdfAreaCircleElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DRAW, "area-circle" );

    /**
     * Create the instance of OdfAreaCircleElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfAreaCircleElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink draw:area-circle}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfAreaCircleElement}
     *
     *@param cx  The mandatory attribute {@attributeName  svg:cx}" 
     *@param cy  The mandatory attribute {@attributeName  svg:cy}" 
     *@param r  The mandatory attribute {@attributeName  svg:r}" 
     *
     */
    public void init(OdfLength cx, OdfLength cy, OdfLength r)
    {
        setCx( cx );
        setCy( cy );
        setR( r );
    }

    /**
     * Get value of attribute {@attributeName xlink:href}.
     *
     *@return return the attribute which type is OdfAnyURI
     */
    public OdfAnyURI getHref()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XLINK, "href" ) );
        return OdfAnyURI.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xlink:href}.
     *
     *@param  href    the attribute's type is OdfAnyURI
     */ 
     public void setHref( OdfAnyURI href )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "href" ), href.toString() );
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "type" ), "simple" );
    }

    /**
     * Get value of attribute {@attributeName office:target-frame-name}.
     *
     *@return return the attribute which type is OdfTargetFrameNameType
     */
    public OdfTargetFrameNameType getTargetFrameName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "target-frame-name" ) );
        return OdfTargetFrameNameType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName office:target-frame-name}.
     *
     *@param  targetFrameName    the attribute's type is OdfTargetFrameNameType
     */ 
     public void setTargetFrameName( OdfTargetFrameNameType targetFrameName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "target-frame-name" ), targetFrameName.toString() );
    }

    /**
     * Get value of attribute {@attributeName xlink:show}.
     *
     *@return return the attribute which type is OdfShowType
     */
    public OdfShowType getShow()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XLINK, "show" ) );
        return OdfShowType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xlink:show}.
     *
     *@param  show    the attribute's type is OdfShowType
     */ 
     public void setShow( OdfShowType show )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "show" ), show.toString() );
    }

    /**
     * Get value of attribute {@attributeName office:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "name" ) );
    }

    /**
     * Set value of attribute {@attributeName office:name}.
     *
     *@param  name    the attribute's type is String
     */ 
     public void setName( String name )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "name" ), name );
    }

    /**
     * Get value of attribute {@attributeName draw:nohref}.
     *
     *@return return the attribute which type is String
     */
    public String getNohref()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "nohref" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:nohref}.
     *
     *@param  nohref    the attribute's type is String
     */ 
     public void setNohref( String nohref )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "nohref" ), nohref );
    }

    /**
     * Get value of attribute {@attributeName svg:cx}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getCx()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "cx" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:cx}.
     *
     *@param  cx    the attribute's type is OdfLength
     */ 
     public void setCx( OdfLength cx )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "cx" ), cx.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:cy}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getCy()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "cy" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:cy}.
     *
     *@param  cy    the attribute's type is OdfLength
     */ 
     public void setCy( OdfLength cy )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "cy" ), cy.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:r}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getR()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "r" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:r}.
     *
     *@param  r    the attribute's type is OdfLength
     */ 
     public void setR( OdfLength r )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "r" ), r.toString() );
    }

    /**
    * Create child element {@odfLink svg:title}.
    *
    *@return   return  the element {@odfLink svg:title}
    */
    public OdfTitleElement createTitleElement()
    {
        OdfTitleElement  nTitle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTitleElement.class);
        this.appendChild( nTitle);
        return  nTitle;
    }                   
               
    /**
    * Create child element {@odfLink svg:desc}.
    *
    *@return   return  the element {@odfLink svg:desc}
    */
    public OdfDescElement createDescElement()
    {
        OdfDescElement  nDesc = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDescElement.class);
        this.appendChild( nDesc);
        return  nDesc;
    }                   
               
    /**
    * Create child element {@odfLink office:event-listeners}.
    *
    *@return   return  the element {@odfLink office:event-listeners}
    */
    public OdfEventListenersElement createEventListenersElement()
    {
        OdfEventListenersElement  nEventListeners = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfEventListenersElement.class);
        this.appendChild( nEventListeners);
        return  nEventListeners;
    }                   
               
}
