/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.draw;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.OdfId;
import java.net.URI;
import org.odftoolkit.odfdom.dom.type.OdfAnyURI;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink draw:applet}.
 *
 */
public abstract class OdfAppletElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DRAW, "applet" );

    /**
     * Create the instance of OdfAppletElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfAppletElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink draw:applet}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName draw:code}.
     *
     *@return return the attribute which type is String
     */
    public String getCode()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "code" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:code}.
     *
     *@param  code    the attribute's type is String
     */ 
     public void setCode( String code )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "code" ), code );
    }

    /**
     * Get value of attribute {@attributeName draw:object}.
     *
     *@return return the attribute which type is String
     */
    public String getObject()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "object" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:object}.
     *
     *@param  object    the attribute's type is String
     */ 
     public void setObject( String object )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "object" ), object );
    }

    /**
     * Get value of attribute {@attributeName draw:archive}.
     *
     *@return return the attribute which type is String
     */
    public String getArchive()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "archive" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:archive}.
     *
     *@param  archive    the attribute's type is String
     */ 
     public void setArchive( String archive )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "archive" ), archive );
    }

    /**
     * Get value of attribute {@attributeName draw:may-script}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getMayScript()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "may-script" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:may-script}.
     *
     *@param  isMayScript    the attribute's type is OdfBoolean
     */ 
     public void setMayScript( OdfBoolean isMayScript )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "may-script" ), isMayScript.toString() );
    }

    /**
     * Get value of attribute {@attributeName xml:id}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getXmlid()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xml:id}.
     *
     *@param  xmlid    the attribute's type is OdfId
     */ 
     public void setXmlid( OdfId xmlid )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ), xmlid.toString() );
    }

    /**
     * Get value of attribute {@attributeName xlink:href}.
     *
     *@return return the attribute which type is OdfAnyURI
     */
    public OdfAnyURI getHref()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XLINK, "href" ) );
        return OdfAnyURI.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xlink:href}.
     *
     *@param  href    the attribute's type is OdfAnyURI
     */ 
     public void setHref( OdfAnyURI href )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "href" ), href.toString() );
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "type" ), "simple" );
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "show" ), "embed" );
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "actuate" ), "onLoad" );
    }

    /**
    * Create child element {@odfLink draw:param}.
    *
    *@return   return  the element {@odfLink draw:param}
    */
    public OdfParamElement createParamElement()
    {
        OdfParamElement  nParam = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfParamElement.class);
        this.appendChild( nParam);
        return  nParam;
    }                   
               
}
