/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.dr3d;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.element.OdfStyleablePresentationElement;
import org.odftoolkit.odfdom.dom.type.dr3d.OdfProjectionType;
import org.odftoolkit.odfdom.dom.type.OdfLength;
import org.odftoolkit.odfdom.dom.type.dr3d.OdfShadeModeType;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;
import java.util.List;
import org.odftoolkit.odfdom.dom.type.OdfStyleNames;
import org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger;
import org.odftoolkit.odfdom.dom.type.OdfId;
import org.odftoolkit.odfdom.dom.type.OdfCellAddress;
import org.odftoolkit.odfdom.dom.type.text.OdfAnchorType;
import org.odftoolkit.odfdom.dom.type.OdfPositiveInteger;

import org.odftoolkit.odfdom.dom.element.svg.OdfTitleElement;
import org.odftoolkit.odfdom.dom.element.svg.OdfDescElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfGluePointElement;
import org.odftoolkit.odfdom.dom.type.draw.OdfEscapeDirectionType;

/**
 * DOM implementation of OpenDocument element  {@odfLink dr3d:scene}.
 *
 */
public abstract class OdfSceneElement extends OdfStyleablePresentationElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DR3D, "scene" );

    /**
     * Create the instance of OdfSceneElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfSceneElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink dr3d:scene}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName dr3d:vrp}.
     *
     *@return return the attribute which type is String
     */
    public String getVrp()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DR3D, "vrp" ) );
    }

    /**
     * Set value of attribute {@attributeName dr3d:vrp}.
     *
     *@param  vrp    the attribute's type is String
     */ 
     public void setVrp( String vrp )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DR3D, "vrp" ), vrp );
    }

    /**
     * Get value of attribute {@attributeName dr3d:vpn}.
     *
     *@return return the attribute which type is String
     */
    public String getVpn()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DR3D, "vpn" ) );
    }

    /**
     * Set value of attribute {@attributeName dr3d:vpn}.
     *
     *@param  vpn    the attribute's type is String
     */ 
     public void setVpn( String vpn )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DR3D, "vpn" ), vpn );
    }

    /**
     * Get value of attribute {@attributeName dr3d:vup}.
     *
     *@return return the attribute which type is String
     */
    public String getVup()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DR3D, "vup" ) );
    }

    /**
     * Set value of attribute {@attributeName dr3d:vup}.
     *
     *@param  vup    the attribute's type is String
     */ 
     public void setVup( String vup )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DR3D, "vup" ), vup );
    }

    /**
     * Get value of attribute {@attributeName dr3d:projection}.
     *
     *@return return the attribute which type is OdfProjectionType
     */
    public OdfProjectionType getProjection()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DR3D, "projection" ) );
        return OdfProjectionType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName dr3d:projection}.
     *
     *@param  projection    the attribute's type is OdfProjectionType
     */ 
     public void setProjection( OdfProjectionType projection )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DR3D, "projection" ), projection.toString() );
    }

    /**
     * Get value of attribute {@attributeName dr3d:distance}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getDistance()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DR3D, "distance" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName dr3d:distance}.
     *
     *@param  distance    the attribute's type is OdfLength
     */ 
     public void setDistance( OdfLength distance )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DR3D, "distance" ), distance.toString() );
    }

    /**
     * Get value of attribute {@attributeName dr3d:focal-length}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getFocalLength()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DR3D, "focal-length" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName dr3d:focal-length}.
     *
     *@param  focalLength    the attribute's type is OdfLength
     */ 
     public void setFocalLength( OdfLength focalLength )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DR3D, "focal-length" ), focalLength.toString() );
    }

    /**
     * Get value of attribute {@attributeName dr3d:shadow-slant}.
     *
     *@return return the attribute which type is String
     */
    public String getShadowSlant()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DR3D, "shadow-slant" ) );
    }

    /**
     * Set value of attribute {@attributeName dr3d:shadow-slant}.
     *
     *@param  shadowSlant    the attribute's type is String
     */ 
     public void setShadowSlant( String shadowSlant )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DR3D, "shadow-slant" ), shadowSlant );
    }

    /**
     * Get value of attribute {@attributeName dr3d:shade-mode}.
     *
     *@return return the attribute which type is OdfShadeModeType
     */
    public OdfShadeModeType getShadeMode()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DR3D, "shade-mode" ) );
        return OdfShadeModeType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName dr3d:shade-mode}.
     *
     *@param  shadeMode    the attribute's type is OdfShadeModeType
     */ 
     public void setShadeMode( OdfShadeModeType shadeMode )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DR3D, "shade-mode" ), shadeMode.toString() );
    }

    /**
     * Get value of attribute {@attributeName dr3d:ambient-color}.
     *
     *@return return the attribute which type is String
     */
    public String getAmbientColor()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DR3D, "ambient-color" ) );
    }

    /**
     * Set value of attribute {@attributeName dr3d:ambient-color}.
     *
     *@param  ambientColor    the attribute's type is String
     */ 
     public void setAmbientColor( String ambientColor )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DR3D, "ambient-color" ), ambientColor );
    }

    /**
     * Get value of attribute {@attributeName dr3d:lighting-mode}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getLightingMode()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DR3D, "lighting-mode" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName dr3d:lighting-mode}.
     *
     *@param  isLightingMode    the attribute's type is OdfBoolean
     */ 
     public void setLightingMode( OdfBoolean isLightingMode )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DR3D, "lighting-mode" ), isLightingMode.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:x}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getX()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "x" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:x}.
     *
     *@param  x    the attribute's type is OdfLength
     */ 
     public void setX( OdfLength x )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "x" ), x.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:y}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getY()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "y" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:y}.
     *
     *@param  y    the attribute's type is OdfLength
     */ 
     public void setY( OdfLength y )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "y" ), y.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:width}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getWidth()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "width" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:width}.
     *
     *@param  width    the attribute's type is OdfLength
     */ 
     public void setWidth( OdfLength width )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "width" ), width.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:height}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getHeight()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "height" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:height}.
     *
     *@param  height    the attribute's type is OdfLength
     */ 
     public void setHeight( OdfLength height )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "height" ), height.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getDrawStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:style-name}.
     *
     *@param  drawStyleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setDrawStyleName( OdfStyleNameRef drawStyleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "style-name" ), drawStyleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:class-names}.
     *
     *@return return the attribute which type is List<String>
     */
    public List<String> getDrawClassNames()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "class-names" ) );
        return OdfStyleNames.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:class-names}.
     *
     *@param  drawClassNames    the attribute's type is OdfStyleNames
     */ 
     public void setDrawClassNames( OdfStyleNames drawClassNames )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "class-names" ), drawClassNames.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getPresentationStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:style-name}.
     *
     *@param  presentationStyleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setPresentationStyleName( OdfStyleNameRef presentationStyleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "style-name" ), presentationStyleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:class-names}.
     *
     *@return return the attribute which type is List<String>
     */
    public List<String> getPresentationClassNames()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "class-names" ) );
        return OdfStyleNames.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:class-names}.
     *
     *@param  presentationClassNames    the attribute's type is OdfStyleNames
     */ 
     public void setPresentationClassNames( OdfStyleNames presentationClassNames )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "class-names" ), presentationClassNames.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:z-index}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getZIndex()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "z-index" ) );
        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:z-index}.
     *
     *@param  zIndex    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setZIndex( OdfNonNegativeInteger zIndex )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "z-index" ), zIndex.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:id}.
     *
     *@return return the attribute which type is String
     */
    public String getDrawid()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "id" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:id}.
     *
     *@param  drawid    the attribute's type is String
     */ 
     public void setDrawid( String drawid )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "id" ), drawid );
    }

    /**
     * Get value of attribute {@attributeName xml:id}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getXmlid()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xml:id}.
     *
     *@param  xmlid    the attribute's type is OdfId
     */ 
     public void setXmlid( OdfId xmlid )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ), xmlid.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:layer}.
     *
     *@return return the attribute which type is String
     */
    public String getLayer()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "layer" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:layer}.
     *
     *@param  layer    the attribute's type is String
     */ 
     public void setLayer( String layer )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "layer" ), layer );
    }

    /**
     * Get value of attribute {@attributeName table:end-cell-address}.
     *
     *@return return the attribute which type is OdfCellAddress
     */
    public OdfCellAddress getEndCellAddress()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "end-cell-address" ) );
        return OdfCellAddress.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:end-cell-address}.
     *
     *@param  endCellAddress    the attribute's type is OdfCellAddress
     */ 
     public void setEndCellAddress( OdfCellAddress endCellAddress )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "end-cell-address" ), endCellAddress.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:end-x}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getEndX()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "end-x" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:end-x}.
     *
     *@param  endX    the attribute's type is OdfLength
     */ 
     public void setEndX( OdfLength endX )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "end-x" ), endX.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:end-y}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getEndY()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "end-y" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:end-y}.
     *
     *@param  endY    the attribute's type is OdfLength
     */ 
     public void setEndY( OdfLength endY )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "end-y" ), endY.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:table-background}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getTableBackground()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "table-background" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:table-background}.
     *
     *@param  isTableBackground    the attribute's type is OdfBoolean
     */ 
     public void setTableBackground( OdfBoolean isTableBackground )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "table-background" ), isTableBackground.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:anchor-type}.
     *
     *@return return the attribute which type is OdfAnchorType
     */
    public OdfAnchorType getAnchorType()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "anchor-type" ) );
        return OdfAnchorType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:anchor-type}.
     *
     *@param  anchorType    the attribute's type is OdfAnchorType
     */ 
     public void setAnchorType( OdfAnchorType anchorType )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "anchor-type" ), anchorType.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:anchor-page-number}.
     *
     *@return return the attribute which type is OdfPositiveInteger
     */
    public OdfPositiveInteger getAnchorPageNumber()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "anchor-page-number" ) );
        return OdfPositiveInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:anchor-page-number}.
     *
     *@param  anchorPageNumber    the attribute's type is OdfPositiveInteger
     */ 
     public void setAnchorPageNumber( OdfPositiveInteger anchorPageNumber )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "anchor-page-number" ), anchorPageNumber.toString() );
    }

    /**
     * Get value of attribute {@attributeName dr3d:transform}.
     *
     *@return return the attribute which type is String
     */
    public String getTransform()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DR3D, "transform" ) );
    }

    /**
     * Set value of attribute {@attributeName dr3d:transform}.
     *
     *@param  transform    the attribute's type is String
     */ 
     public void setTransform( String transform )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DR3D, "transform" ), transform );
    }

    /**
     * Get value of attribute {@attributeName draw:caption-id}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getCaptionId()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "caption-id" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:caption-id}.
     *
     *@param  captionId    the attribute's type is OdfId
     */ 
     public void setCaptionId( OdfId captionId )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "caption-id" ), captionId.toString() );
    }

    /**
    * Create child element {@odfLink svg:title}.
    *
    *@return   return  the element {@odfLink svg:title}
    */
    public OdfTitleElement createTitleElement()
    {
        OdfTitleElement  nTitle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTitleElement.class);
        this.appendChild( nTitle);
        return  nTitle;
    }                   
               
    /**
    * Create child element {@odfLink svg:desc}.
    *
    *@return   return  the element {@odfLink svg:desc}
    */
    public OdfDescElement createDescElement()
    {
        OdfDescElement  nDesc = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDescElement.class);
        this.appendChild( nDesc);
        return  nDesc;
    }                   
               
    /**
    * Create child element {@odfLink dr3d:light}.
    *
    *@param direction String   
    *@return   return  the element {@odfLink dr3d:light}
    */
    public OdfLightElement createLightElement(String   direction)
    {
        OdfLightElement  nLight = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfLightElement.class);
        nLight.setDirection( direction);
        this.appendChild( nLight);
        return  nLight;      
    }
    
    /**
    * Create child element {@odfLink dr3d:scene}.
    *
    *@return   return  the element {@odfLink dr3d:scene}
    */
    public OdfSceneElement createSceneElement()
    {
        OdfSceneElement  nScene = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSceneElement.class);
        this.appendChild( nScene);
        return  nScene;
    }                   
               
    /**
    * Create child element {@odfLink dr3d:extrude}.
    *
    *@param d String   
    *@param viewBox Integer   
    *@return   return  the element {@odfLink dr3d:extrude}
    */
    public OdfExtrudeElement createExtrudeElement(String   d, Integer   viewBox)
    {
        OdfExtrudeElement  nExtrude = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfExtrudeElement.class);
        nExtrude.setD( d);
        nExtrude.setViewBox( viewBox);
        this.appendChild( nExtrude);
        return  nExtrude;      
    }
    
    /**
    * Create child element {@odfLink dr3d:sphere}.
    *
    *@return   return  the element {@odfLink dr3d:sphere}
    */
    public OdfSphereElement createSphereElement()
    {
        OdfSphereElement  nSphere = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSphereElement.class);
        this.appendChild( nSphere);
        return  nSphere;
    }                   
               
    /**
    * Create child element {@odfLink dr3d:rotate}.
    *
    *@param viewBox Integer   
    *@param d String   
    *@return   return  the element {@odfLink dr3d:rotate}
    */
    public OdfRotateElement createRotateElement(Integer   viewBox, String   d)
    {
        OdfRotateElement  nRotate = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfRotateElement.class);
        nRotate.setViewBox( viewBox);
        nRotate.setD( d);
        this.appendChild( nRotate);
        return  nRotate;      
    }
    
    /**
    * Create child element {@odfLink dr3d:cube}.
    *
    *@return   return  the element {@odfLink dr3d:cube}
    */
    public OdfCubeElement createCubeElement()
    {
        OdfCubeElement  nCube = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCubeElement.class);
        this.appendChild( nCube);
        return  nCube;
    }                   
               
    /**
    * Create child element {@odfLink draw:glue-point}.
    *
    *@param drawid  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger
    *@param x  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param y  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param escapeDirection     the attribute's type is OdfEscapeDirectionType, see {@attributeName  draw:escape-direction} at specification
    *@return   return  the element {@odfLink draw:glue-point}
    */
    public OdfGluePointElement createGluePointElement(org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger   drawid, org.odftoolkit.odfdom.dom.type.OdfLength   x, org.odftoolkit.odfdom.dom.type.OdfLength   y, OdfEscapeDirectionType   escapeDirection)
    {
        OdfGluePointElement  nGluePoint = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfGluePointElement.class);
        nGluePoint.setDrawid( drawid);
        nGluePoint.setX( x);
        nGluePoint.setY( y);
        nGluePoint.setEscapeDirection( escapeDirection);
        this.appendChild( nGluePoint);
        return  nGluePoint;      
    }
    
}
