/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.dr3d;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink dr3d:light}.
 *
 */
public abstract class OdfLightElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DR3D, "light" );

    /**
     * Create the instance of OdfLightElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfLightElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink dr3d:light}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfLightElement}
     *
     *@param direction  The mandatory attribute {@attributeName  dr3d:direction}" 
     *
     */
    public void init(String direction)
    {
        setDirection( direction );
    }

    /**
     * Get value of attribute {@attributeName dr3d:diffuse-color}.
     *
     *@return return the attribute which type is String
     */
    public String getDiffuseColor()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DR3D, "diffuse-color" ) );
    }

    /**
     * Set value of attribute {@attributeName dr3d:diffuse-color}.
     *
     *@param  diffuseColor    the attribute's type is String
     */ 
     public void setDiffuseColor( String diffuseColor )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DR3D, "diffuse-color" ), diffuseColor );
    }

    /**
     * Get value of attribute {@attributeName dr3d:direction}.
     *
     *@return return the attribute which type is String
     */
    public String getDirection()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DR3D, "direction" ) );
    }

    /**
     * Set value of attribute {@attributeName dr3d:direction}.
     *
     *@param  direction    the attribute's type is String
     */ 
     public void setDirection( String direction )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DR3D, "direction" ), direction );
    }

    /**
     * Get value of attribute {@attributeName dr3d:enabled}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getEnabled()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DR3D, "enabled" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName dr3d:enabled}.
     *
     *@param  isEnabled    the attribute's type is OdfBoolean
     */ 
     public void setEnabled( OdfBoolean isEnabled )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DR3D, "enabled" ), isEnabled.toString() );
    }

    /**
     * Get value of attribute {@attributeName dr3d:specular}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getSpecular()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DR3D, "specular" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName dr3d:specular}.
     *
     *@param  isSpecular    the attribute's type is OdfBoolean
     */ 
     public void setSpecular( OdfBoolean isSpecular )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DR3D, "specular" ), isSpecular.toString() );
    }

}
