/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.dr3d;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.element.OdfStyleablePresentationElement;
import org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger;
import org.odftoolkit.odfdom.dom.type.OdfId;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;
import java.util.List;
import org.odftoolkit.odfdom.dom.type.OdfStyleNames;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink dr3d:cube}.
 *
 */
public abstract class OdfCubeElement extends OdfStyleablePresentationElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DR3D, "cube" );

    /**
     * Create the instance of OdfCubeElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfCubeElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink dr3d:cube}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName dr3d:min-edge}.
     *
     *@return return the attribute which type is String
     */
    public String getMinEdge()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DR3D, "min-edge" ) );
    }

    /**
     * Set value of attribute {@attributeName dr3d:min-edge}.
     *
     *@param  minEdge    the attribute's type is String
     */ 
     public void setMinEdge( String minEdge )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DR3D, "min-edge" ), minEdge );
    }

    /**
     * Get value of attribute {@attributeName dr3d:max-edge}.
     *
     *@return return the attribute which type is String
     */
    public String getMaxEdge()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DR3D, "max-edge" ) );
    }

    /**
     * Set value of attribute {@attributeName dr3d:max-edge}.
     *
     *@param  maxEdge    the attribute's type is String
     */ 
     public void setMaxEdge( String maxEdge )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DR3D, "max-edge" ), maxEdge );
    }

    /**
     * Get value of attribute {@attributeName draw:z-index}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getZIndex()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "z-index" ) );
        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:z-index}.
     *
     *@param  zIndex    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setZIndex( OdfNonNegativeInteger zIndex )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "z-index" ), zIndex.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:id}.
     *
     *@return return the attribute which type is String
     */
    public String getDrawid()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "id" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:id}.
     *
     *@param  drawid    the attribute's type is String
     */ 
     public void setDrawid( String drawid )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "id" ), drawid );
    }

    /**
     * Get value of attribute {@attributeName xml:id}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getXmlid()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xml:id}.
     *
     *@param  xmlid    the attribute's type is OdfId
     */ 
     public void setXmlid( OdfId xmlid )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ), xmlid.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:layer}.
     *
     *@return return the attribute which type is String
     */
    public String getLayer()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "layer" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:layer}.
     *
     *@param  layer    the attribute's type is String
     */ 
     public void setLayer( String layer )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "layer" ), layer );
    }

    /**
     * Get value of attribute {@attributeName draw:style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getDrawStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:style-name}.
     *
     *@param  drawStyleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setDrawStyleName( OdfStyleNameRef drawStyleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "style-name" ), drawStyleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:class-names}.
     *
     *@return return the attribute which type is List<String>
     */
    public List<String> getDrawClassNames()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "class-names" ) );
        return OdfStyleNames.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:class-names}.
     *
     *@param  drawClassNames    the attribute's type is OdfStyleNames
     */ 
     public void setDrawClassNames( OdfStyleNames drawClassNames )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "class-names" ), drawClassNames.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getPresentationStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:style-name}.
     *
     *@param  presentationStyleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setPresentationStyleName( OdfStyleNameRef presentationStyleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "style-name" ), presentationStyleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:class-names}.
     *
     *@return return the attribute which type is List<String>
     */
    public List<String> getPresentationClassNames()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "class-names" ) );
        return OdfStyleNames.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:class-names}.
     *
     *@param  presentationClassNames    the attribute's type is OdfStyleNames
     */ 
     public void setPresentationClassNames( OdfStyleNames presentationClassNames )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "class-names" ), presentationClassNames.toString() );
    }

    /**
     * Get value of attribute {@attributeName dr3d:transform}.
     *
     *@return return the attribute which type is String
     */
    public String getTransform()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DR3D, "transform" ) );
    }

    /**
     * Set value of attribute {@attributeName dr3d:transform}.
     *
     *@param  transform    the attribute's type is String
     */ 
     public void setTransform( String transform )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DR3D, "transform" ), transform );
    }

}
