/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.db;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink db:table-definition}.
 *
 */
public abstract class OdfTableDefinitionElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DB, "table-definition" );

    /**
     * Create the instance of OdfTableDefinitionElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfTableDefinitionElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink db:table-definition}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfTableDefinitionElement}
     *
     *@param name  The mandatory attribute {@attributeName  db:name}" 
     *
     */
    public void init(String name)
    {
        setName( name );
    }

    /**
     * Get value of attribute {@attributeName db:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DB, "name" ) );
    }

    /**
     * Set value of attribute {@attributeName db:name}.
     *
     *@param  name    the attribute's type is String
     */ 
     public void setName( String name )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "name" ), name );
    }

    /**
     * Get value of attribute {@attributeName db:catalog-name}.
     *
     *@return return the attribute which type is String
     */
    public String getCatalogName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DB, "catalog-name" ) );
    }

    /**
     * Set value of attribute {@attributeName db:catalog-name}.
     *
     *@param  catalogName    the attribute's type is String
     */ 
     public void setCatalogName( String catalogName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "catalog-name" ), catalogName );
    }

    /**
     * Get value of attribute {@attributeName db:schema-name}.
     *
     *@return return the attribute which type is String
     */
    public String getSchemaName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DB, "schema-name" ) );
    }

    /**
     * Set value of attribute {@attributeName db:schema-name}.
     *
     *@param  schemaName    the attribute's type is String
     */ 
     public void setSchemaName( String schemaName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "schema-name" ), schemaName );
    }

    /**
     * Get value of attribute {@attributeName db:type}.
     *
     *@return return the attribute which type is String
     */
    public String getType()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DB, "type" ) );
    }

    /**
     * Set value of attribute {@attributeName db:type}.
     *
     *@param  type    the attribute's type is String
     */ 
     public void setType( String type )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "type" ), type );
    }

    /**
    * Create child element {@odfLink db:column-definitions}.
    *
    *@return   return  the element {@odfLink db:column-definitions}
    */
    public OdfColumnDefinitionsElement createColumnDefinitionsElement()
    {
        OdfColumnDefinitionsElement  nColumnDefinitions = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfColumnDefinitionsElement.class);
        this.appendChild( nColumnDefinitions);
        return  nColumnDefinitions;
    }                   
               
    /**
    * Create child element {@odfLink db:keys}.
    *
    *@return   return  the element {@odfLink db:keys}
    */
    public OdfKeysElement createKeysElement()
    {
        OdfKeysElement  nKeys = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfKeysElement.class);
        this.appendChild( nKeys);
        return  nKeys;
    }                   
               
    /**
    * Create child element {@odfLink db:indices}.
    *
    *@return   return  the element {@odfLink db:indices}
    */
    public OdfIndicesElement createIndicesElement()
    {
        OdfIndicesElement  nIndices = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfIndicesElement.class);
        this.appendChild( nIndices);
        return  nIndices;
    }                   
               
}
