/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.db;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfPositiveInteger;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink db:server-database}.
 *
 */
public abstract class OdfServerDatabaseElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DB, "server-database" );

    /**
     * Create the instance of OdfServerDatabaseElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfServerDatabaseElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink db:server-database}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfServerDatabaseElement}
     *
     *@param type  The mandatory attribute {@attributeName  db:type}" 
     *@param hostname  The mandatory attribute {@attributeName  db:hostname}" 
     *
     */
    public void init(String type, String hostname)
    {
        setType( type );
        setHostname( hostname );
    }

    /**
     * Get value of attribute {@attributeName db:type}.
     *
     *@return return the attribute which type is String
     */
    public String getType()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DB, "type" ) );
    }

    /**
     * Set value of attribute {@attributeName db:type}.
     *
     *@param  type    the attribute's type is String
     */ 
     public void setType( String type )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "type" ), type );
    }

    /**
     * Get value of attribute {@attributeName db:hostname}.
     *
     *@return return the attribute which type is String
     */
    public String getHostname()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DB, "hostname" ) );
    }

    /**
     * Set value of attribute {@attributeName db:hostname}.
     *
     *@param  hostname    the attribute's type is String
     */ 
     public void setHostname( String hostname )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "hostname" ), hostname );
    }

    /**
     * Get value of attribute {@attributeName db:port}.
     *
     *@return return the attribute which type is OdfPositiveInteger
     */
    public OdfPositiveInteger getPort()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "port" ) );
        return OdfPositiveInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:port}.
     *
     *@param  port    the attribute's type is OdfPositiveInteger
     */ 
     public void setPort( OdfPositiveInteger port )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "port" ), port.toString() );
    }

    /**
     * Get value of attribute {@attributeName db:local-socket}.
     *
     *@return return the attribute which type is String
     */
    public String getLocalSocket()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DB, "local-socket" ) );
    }

    /**
     * Set value of attribute {@attributeName db:local-socket}.
     *
     *@param  localSocket    the attribute's type is String
     */ 
     public void setLocalSocket( String localSocket )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "local-socket" ), localSocket );
    }

    /**
     * Get value of attribute {@attributeName db:database-name}.
     *
     *@return return the attribute which type is String
     */
    public String getDatabaseName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DB, "database-name" ) );
    }

    /**
     * Set value of attribute {@attributeName db:database-name}.
     *
     *@param  databaseName    the attribute's type is String
     */ 
     public void setDatabaseName( String databaseName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "database-name" ), databaseName );
    }

}
