/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.db;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink db:query}.
 *
 */
public abstract class OdfQueryElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DB, "query" );

    /**
     * Create the instance of OdfQueryElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfQueryElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink db:query}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfQueryElement}
     *
     *@param command  The mandatory attribute {@attributeName  db:command}" 
     *@param name  The mandatory attribute {@attributeName  db:name}" 
     *
     */
    public void init(String command, String name)
    {
        setCommand( command );
        setName( name );
    }

    /**
     * Get value of attribute {@attributeName db:command}.
     *
     *@return return the attribute which type is String
     */
    public String getCommand()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DB, "command" ) );
    }

    /**
     * Set value of attribute {@attributeName db:command}.
     *
     *@param  command    the attribute's type is String
     */ 
     public void setCommand( String command )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "command" ), command );
    }

    /**
     * Get value of attribute {@attributeName db:escape-processing}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getEscapeProcessing()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "escape-processing" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:escape-processing}.
     *
     *@param  isEscapeProcessing    the attribute's type is OdfBoolean
     */ 
     public void setEscapeProcessing( OdfBoolean isEscapeProcessing )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "escape-processing" ), isEscapeProcessing.toString() );
    }

    /**
     * Get value of attribute {@attributeName db:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DB, "name" ) );
    }

    /**
     * Set value of attribute {@attributeName db:name}.
     *
     *@param  name    the attribute's type is String
     */ 
     public void setName( String name )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "name" ), name );
    }

    /**
     * Get value of attribute {@attributeName db:title}.
     *
     *@return return the attribute which type is String
     */
    public String getTitle()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DB, "title" ) );
    }

    /**
     * Set value of attribute {@attributeName db:title}.
     *
     *@param  title    the attribute's type is String
     */ 
     public void setTitle( String title )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "title" ), title );
    }

    /**
     * Get value of attribute {@attributeName db:description}.
     *
     *@return return the attribute which type is String
     */
    public String getDescription()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DB, "description" ) );
    }

    /**
     * Set value of attribute {@attributeName db:description}.
     *
     *@param  description    the attribute's type is String
     */ 
     public void setDescription( String description )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "description" ), description );
    }

    /**
     * Get value of attribute {@attributeName db:style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:style-name}.
     *
     *@param  styleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setStyleName( OdfStyleNameRef styleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "style-name" ), styleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName db:default-row-style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getDefaultRowStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "default-row-style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:default-row-style-name}.
     *
     *@param  defaultRowStyleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setDefaultRowStyleName( OdfStyleNameRef defaultRowStyleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "default-row-style-name" ), defaultRowStyleName.toString() );
    }

    /**
    * Create child element {@odfLink db:order-statement}.
    *
    *@param command String   
    *@return   return  the element {@odfLink db:order-statement}
    */
    public OdfOrderStatementElement createOrderStatementElement(String   command)
    {
        OdfOrderStatementElement  nOrderStatement = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfOrderStatementElement.class);
        nOrderStatement.setCommand( command);
        this.appendChild( nOrderStatement);
        return  nOrderStatement;      
    }
    
    /**
    * Create child element {@odfLink db:filter-statement}.
    *
    *@param command String   
    *@return   return  the element {@odfLink db:filter-statement}
    */
    public OdfFilterStatementElement createFilterStatementElement(String   command)
    {
        OdfFilterStatementElement  nFilterStatement = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFilterStatementElement.class);
        nFilterStatement.setCommand( command);
        this.appendChild( nFilterStatement);
        return  nFilterStatement;      
    }
    
    /**
    * Create child element {@odfLink db:columns}.
    *
    *@return   return  the element {@odfLink db:columns}
    */
    public OdfColumnsElement createColumnsElement()
    {
        OdfColumnsElement  nColumns = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfColumnsElement.class);
        this.appendChild( nColumns);
        return  nColumns;
    }                   
               
    /**
    * Create child element {@odfLink db:update-table}.
    *
    *@param name String   
    *@return   return  the element {@odfLink db:update-table}
    */
    public OdfUpdateTableElement createUpdateTableElement(String   name)
    {
        OdfUpdateTableElement  nUpdateTable = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfUpdateTableElement.class);
        nUpdateTable.setName( name);
        this.appendChild( nUpdateTable);
        return  nUpdateTable;      
    }
    
}
