/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.db;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink db:order-statement}.
 *
 */
public abstract class OdfOrderStatementElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DB, "order-statement" );

    /**
     * Create the instance of OdfOrderStatementElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfOrderStatementElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink db:order-statement}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfOrderStatementElement}
     *
     *@param command  The mandatory attribute {@attributeName  db:command}" 
     *
     */
    public void init(String command)
    {
        setCommand( command );
    }

    /**
     * Get value of attribute {@attributeName db:command}.
     *
     *@return return the attribute which type is String
     */
    public String getCommand()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DB, "command" ) );
    }

    /**
     * Set value of attribute {@attributeName db:command}.
     *
     *@param  command    the attribute's type is String
     */ 
     public void setCommand( String command )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "command" ), command );
    }

    /**
     * Get value of attribute {@attributeName db:apply-command}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getApplyCommand()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "apply-command" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:apply-command}.
     *
     *@param  isApplyCommand    the attribute's type is OdfBoolean
     */ 
     public void setApplyCommand( OdfBoolean isApplyCommand )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "apply-command" ), isApplyCommand.toString() );
    }

}
