/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.db;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.OdfPositiveInteger;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink db:login}.
 *
 */
public abstract class OdfLoginElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DB, "login" );

    /**
     * Create the instance of OdfLoginElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfLoginElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink db:login}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName db:user-name}.
     *
     *@return return the attribute which type is String
     */
    public String getUserName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DB, "user-name" ) );
    }

    /**
     * Set value of attribute {@attributeName db:user-name}.
     *
     *@param  userName    the attribute's type is String
     */ 
     public void setUserName( String userName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "user-name" ), userName );
    }

    /**
     * Get value of attribute {@attributeName db:use-system-user}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getUseSystemUser()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "use-system-user" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:use-system-user}.
     *
     *@param  isUseSystemUser    the attribute's type is OdfBoolean
     */ 
     public void setUseSystemUser( OdfBoolean isUseSystemUser )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "use-system-user" ), isUseSystemUser.toString() );
    }

    /**
     * Get value of attribute {@attributeName db:is-password-required}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getIsPasswordRequired()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "is-password-required" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:is-password-required}.
     *
     *@param  isIsPasswordRequired    the attribute's type is OdfBoolean
     */ 
     public void setIsPasswordRequired( OdfBoolean isIsPasswordRequired )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "is-password-required" ), isIsPasswordRequired.toString() );
    }

    /**
     * Get value of attribute {@attributeName db:login-timeout}.
     *
     *@return return the attribute which type is OdfPositiveInteger
     */
    public OdfPositiveInteger getLoginTimeout()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "login-timeout" ) );
        return OdfPositiveInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:login-timeout}.
     *
     *@param  loginTimeout    the attribute's type is OdfPositiveInteger
     */ 
     public void setLoginTimeout( OdfPositiveInteger loginTimeout )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "login-timeout" ), loginTimeout.toString() );
    }

}
