/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.db;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.db.OdfType;
import org.odftoolkit.odfdom.dom.type.db.OdfUpdateRuleType;
import org.odftoolkit.odfdom.dom.type.db.OdfDeleteRuleType;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink db:key}.
 *
 */
public abstract class OdfKeyElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DB, "key" );

    /**
     * Create the instance of OdfKeyElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfKeyElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink db:key}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfKeyElement}
     *
     *@param type  The mandatory attribute {@attributeName  db:type}" 
     *
     */
    public void init(OdfType type)
    {
        setType( type );
    }

    /**
     * Get value of attribute {@attributeName db:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DB, "name" ) );
    }

    /**
     * Set value of attribute {@attributeName db:name}.
     *
     *@param  name    the attribute's type is String
     */ 
     public void setName( String name )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "name" ), name );
    }

    /**
     * Get value of attribute {@attributeName db:type}.
     *
     *@return return the attribute which type is OdfType
     */
    public OdfType getType()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "type" ) );
        return OdfType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:type}.
     *
     *@param  type    the attribute's type is OdfType
     */ 
     public void setType( OdfType type )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "type" ), type.toString() );
    }

    /**
     * Get value of attribute {@attributeName db:referenced-table-name}.
     *
     *@return return the attribute which type is String
     */
    public String getReferencedTableName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DB, "referenced-table-name" ) );
    }

    /**
     * Set value of attribute {@attributeName db:referenced-table-name}.
     *
     *@param  referencedTableName    the attribute's type is String
     */ 
     public void setReferencedTableName( String referencedTableName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "referenced-table-name" ), referencedTableName );
    }

    /**
     * Get value of attribute {@attributeName db:update-rule}.
     *
     *@return return the attribute which type is OdfUpdateRuleType
     */
    public OdfUpdateRuleType getUpdateRule()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "update-rule" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "no-action";
        }

        return OdfUpdateRuleType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:update-rule}.
     *
     *@param  updateRule    the attribute's type is OdfUpdateRuleType
     */ 
     public void setUpdateRule( OdfUpdateRuleType updateRule )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "update-rule" ), updateRule.toString() );
    }

    /**
     * Get value of attribute {@attributeName db:delete-rule}.
     *
     *@return return the attribute which type is OdfDeleteRuleType
     */
    public OdfDeleteRuleType getDeleteRule()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "delete-rule" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "no-action";
        }

        return OdfDeleteRuleType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:delete-rule}.
     *
     *@param  deleteRule    the attribute's type is OdfDeleteRuleType
     */ 
     public void setDeleteRule( OdfDeleteRuleType deleteRule )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "delete-rule" ), deleteRule.toString() );
    }

    /**
    * Create child element {@odfLink db:key-columns}.
    *
    *@return   return  the element {@odfLink db:key-columns}
    */
    public OdfKeyColumnsElement createKeyColumnsElement()
    {
        OdfKeyColumnsElement  nKeyColumns = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfKeyColumnsElement.class);
        this.appendChild( nKeyColumns);
        return  nKeyColumns;
    }                   
               
}
