/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.db;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink db:index-columns}.
 *
 */
public abstract class OdfIndexColumnsElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DB, "index-columns" );

    /**
     * Create the instance of OdfIndexColumnsElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfIndexColumnsElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink db:index-columns}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
    * Create child element {@odfLink db:index-column}.
    *
    *@param name String   
    *@param isAscending  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfBoolean
    *@return   return  the element {@odfLink db:index-column}
    */
    public OdfIndexColumnElement createIndexColumnElement(String   name, org.odftoolkit.odfdom.dom.type.OdfBoolean   isAscending)
    {
        OdfIndexColumnElement  nIndexColumn = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfIndexColumnElement.class);
        nIndexColumn.setName( name);
        nIndexColumn.setIsAscending( isAscending);
        this.appendChild( nIndexColumn);
        return  nIndexColumn;      
    }
    
}
