/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.db;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import java.net.URI;
import org.odftoolkit.odfdom.dom.type.OdfAnyURI;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink db:file-based-database}.
 *
 */
public abstract class OdfFileBasedDatabaseElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DB, "file-based-database" );

    /**
     * Create the instance of OdfFileBasedDatabaseElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfFileBasedDatabaseElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink db:file-based-database}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfFileBasedDatabaseElement}
     *
     *@param href  The mandatory attribute {@attributeName  xlink:href}" 
     *@param mediaType  The mandatory attribute {@attributeName  db:media-type}" 
     *
     */
    public void init(OdfAnyURI href, String mediaType)
    {
        setHref( href );
        setMediaType( mediaType );
    }

    /**
     * Get value of attribute {@attributeName xlink:href}.
     *
     *@return return the attribute which type is OdfAnyURI
     */
    public OdfAnyURI getHref()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XLINK, "href" ) );
        return OdfAnyURI.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xlink:href}.
     *
     *@param  href    the attribute's type is OdfAnyURI
     */ 
     public void setHref( OdfAnyURI href )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "href" ), href.toString() );
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "type" ), "simple" );
    }

    /**
     * Get value of attribute {@attributeName db:media-type}.
     *
     *@return return the attribute which type is String
     */
    public String getMediaType()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DB, "media-type" ) );
    }

    /**
     * Set value of attribute {@attributeName db:media-type}.
     *
     *@param  mediaType    the attribute's type is String
     */ 
     public void setMediaType( String mediaType )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "media-type" ), mediaType );
    }

    /**
     * Get value of attribute {@attributeName db:extension}.
     *
     *@return return the attribute which type is String
     */
    public String getExtension()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DB, "extension" ) );
    }

    /**
     * Set value of attribute {@attributeName db:extension}.
     *
     *@param  extension    the attribute's type is String
     */ 
     public void setExtension( String extension )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "extension" ), extension );
    }

}
