/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.db;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink db:driver-settings}.
 *
 */
public abstract class OdfDriverSettingsElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DB, "driver-settings" );

    /**
     * Create the instance of OdfDriverSettingsElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfDriverSettingsElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink db:driver-settings}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName db:java-driver-class}.
     *
     *@return return the attribute which type is String
     */
    public String getJavaDriverClass()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DB, "java-driver-class" ) );
    }

    /**
     * Set value of attribute {@attributeName db:java-driver-class}.
     *
     *@param  javaDriverClass    the attribute's type is String
     */ 
     public void setJavaDriverClass( String javaDriverClass )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "java-driver-class" ), javaDriverClass );
    }

    /**
     * Get value of attribute {@attributeName db:show-deleted}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getShowDeleted()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "show-deleted" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:show-deleted}.
     *
     *@param  isShowDeleted    the attribute's type is OdfBoolean
     */ 
     public void setShowDeleted( OdfBoolean isShowDeleted )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "show-deleted" ), isShowDeleted.toString() );
    }

    /**
     * Get value of attribute {@attributeName db:system-driver-settings}.
     *
     *@return return the attribute which type is String
     */
    public String getSystemDriverSettings()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DB, "system-driver-settings" ) );
    }

    /**
     * Set value of attribute {@attributeName db:system-driver-settings}.
     *
     *@param  systemDriverSettings    the attribute's type is String
     */ 
     public void setSystemDriverSettings( String systemDriverSettings )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "system-driver-settings" ), systemDriverSettings );
    }

    /**
     * Get value of attribute {@attributeName db:base-dn}.
     *
     *@return return the attribute which type is String
     */
    public String getBaseDn()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DB, "base-dn" ) );
    }

    /**
     * Set value of attribute {@attributeName db:base-dn}.
     *
     *@param  baseDn    the attribute's type is String
     */ 
     public void setBaseDn( String baseDn )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "base-dn" ), baseDn );
    }

    /**
     * Get value of attribute {@attributeName db:is-first-row-header-line}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getIsFirstRowHeaderLine()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "is-first-row-header-line" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:is-first-row-header-line}.
     *
     *@param  isIsFirstRowHeaderLine    the attribute's type is OdfBoolean
     */ 
     public void setIsFirstRowHeaderLine( OdfBoolean isIsFirstRowHeaderLine )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "is-first-row-header-line" ), isIsFirstRowHeaderLine.toString() );
    }

    /**
     * Get value of attribute {@attributeName db:parameter-name-substitution}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getParameterNameSubstitution()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "parameter-name-substitution" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:parameter-name-substitution}.
     *
     *@param  isParameterNameSubstitution    the attribute's type is OdfBoolean
     */ 
     public void setParameterNameSubstitution( OdfBoolean isParameterNameSubstitution )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "parameter-name-substitution" ), isParameterNameSubstitution.toString() );
    }

    /**
    * Create child element {@odfLink db:auto-increment}.
    *
    *@return   return  the element {@odfLink db:auto-increment}
    */
    public OdfAutoIncrementElement createAutoIncrementElement()
    {
        OdfAutoIncrementElement  nAutoIncrement = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfAutoIncrementElement.class);
        this.appendChild( nAutoIncrement);
        return  nAutoIncrement;
    }                   
               
    /**
    * Create child element {@odfLink db:delimiter}.
    *
    *@return   return  the element {@odfLink db:delimiter}
    */
    public OdfDelimiterElement createDelimiterElement()
    {
        OdfDelimiterElement  nDelimiter = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDelimiterElement.class);
        this.appendChild( nDelimiter);
        return  nDelimiter;
    }                   
               
    /**
    * Create child element {@odfLink db:character-set}.
    *
    *@return   return  the element {@odfLink db:character-set}
    */
    public OdfCharacterSetElement createCharacterSetElement()
    {
        OdfCharacterSetElement  nCharacterSet = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCharacterSetElement.class);
        this.appendChild( nCharacterSet);
        return  nCharacterSet;
    }                   
               
    /**
    * Create child element {@odfLink db:table-settings}.
    *
    *@return   return  the element {@odfLink db:table-settings}
    */
    public OdfTableSettingsElement createTableSettingsElement()
    {
        OdfTableSettingsElement  nTableSettings = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTableSettingsElement.class);
        this.appendChild( nTableSettings);
        return  nTableSettings;
    }                   
               
}
