/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.db;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink db:delimiter}.
 *
 */
public abstract class OdfDelimiterElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DB, "delimiter" );

    /**
     * Create the instance of OdfDelimiterElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfDelimiterElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink db:delimiter}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName db:field}.
     *
     *@return return the attribute which type is String
     */
    public String getField()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "field" ) );
        if( stringVal.length()==0 )
        {
            stringVal = ";";
        }

        return String.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:field}.
     *
     *@param  field    the attribute's type is String
     */ 
     public void setField( String field )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "field" ), field );
    }

    /**
     * Get value of attribute {@attributeName db:string}.
     *
     *@return return the attribute which type is String
     */
    public String getString()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DB, "string" ) );
    }

    /**
     * Set value of attribute {@attributeName db:string}.
     *
     *@param  string    the attribute's type is String
     */ 
     public void setString( String string )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "string" ), string );
    }

    /**
     * Get value of attribute {@attributeName db:decimal}.
     *
     *@return return the attribute which type is String
     */
    public String getDecimal()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "decimal" ) );
        if( stringVal.length()==0 )
        {
            stringVal = ".";
        }

        return String.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:decimal}.
     *
     *@param  decimal    the attribute's type is String
     */ 
     public void setDecimal( String decimal )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "decimal" ), decimal );
    }

    /**
     * Get value of attribute {@attributeName db:thousand}.
     *
     *@return return the attribute which type is String
     */
    public String getThousand()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "thousand" ) );
        if( stringVal.length()==0 )
        {
            stringVal = ",";
        }

        return String.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:thousand}.
     *
     *@param  thousand    the attribute's type is String
     */ 
     public void setThousand( String thousand )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "thousand" ), thousand );
    }

}
