/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.db;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;

import java.net.URI;

/**
 * DOM implementation of OpenDocument element  {@odfLink db:database-description}.
 *
 */
public abstract class OdfDatabaseDescriptionElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DB, "database-description" );

    /**
     * Create the instance of OdfDatabaseDescriptionElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfDatabaseDescriptionElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink db:database-description}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
    * Create child element {@odfLink db:file-based-database}.
    *
    *@param href    the attribute's type is URI
    *@param mediaType String   
    *@return   return  the element {@odfLink db:file-based-database}
    */
    public OdfFileBasedDatabaseElement createFileBasedDatabaseElement(org.odftoolkit.odfdom.dom.type.OdfAnyURI   href, String   mediaType)
    {
        OdfFileBasedDatabaseElement  nFileBasedDatabase = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFileBasedDatabaseElement.class);
        nFileBasedDatabase.setHref( href);
        nFileBasedDatabase.setMediaType( mediaType);
        this.appendChild( nFileBasedDatabase);
        return  nFileBasedDatabase;      
    }
    
    /**
    * Create child element {@odfLink db:server-database}.
    *
    *@param type String   
    *@return   return  the element {@odfLink db:server-database}
    */
    public OdfServerDatabaseElement createServerDatabaseElement(String   type)
    {
        OdfServerDatabaseElement  nServerDatabase = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfServerDatabaseElement.class);
        nServerDatabase.setType( type);
        this.appendChild( nServerDatabase);
        return  nServerDatabase;      
    }
    
}
