/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.db;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.db.OdfDataSourceSettingType;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink db:data-source-setting}.
 *
 */
public abstract class OdfDataSourceSettingElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DB, "data-source-setting" );

    /**
     * Create the instance of OdfDataSourceSettingElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfDataSourceSettingElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink db:data-source-setting}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfDataSourceSettingElement}
     *
     *@param dataSourceSettingName  The mandatory attribute {@attributeName  db:data-source-setting-name}" 
     *@param dataSourceSettingType  The mandatory attribute {@attributeName  db:data-source-setting-type}" 
     *
     */
    public void init(String dataSourceSettingName, OdfDataSourceSettingType dataSourceSettingType)
    {
        setDataSourceSettingName( dataSourceSettingName );
        setDataSourceSettingType( dataSourceSettingType );
    }

    /**
     * Get value of attribute {@attributeName db:data-source-setting-is-list}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getDataSourceSettingIsList()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "data-source-setting-is-list" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:data-source-setting-is-list}.
     *
     *@param  isDataSourceSettingIsList    the attribute's type is OdfBoolean
     */ 
     public void setDataSourceSettingIsList( OdfBoolean isDataSourceSettingIsList )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "data-source-setting-is-list" ), isDataSourceSettingIsList.toString() );
    }

    /**
     * Get value of attribute {@attributeName db:data-source-setting-name}.
     *
     *@return return the attribute which type is String
     */
    public String getDataSourceSettingName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DB, "data-source-setting-name" ) );
    }

    /**
     * Set value of attribute {@attributeName db:data-source-setting-name}.
     *
     *@param  dataSourceSettingName    the attribute's type is String
     */ 
     public void setDataSourceSettingName( String dataSourceSettingName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "data-source-setting-name" ), dataSourceSettingName );
    }

    /**
     * Get value of attribute {@attributeName db:data-source-setting-type}.
     *
     *@return return the attribute which type is OdfDataSourceSettingType
     */
    public OdfDataSourceSettingType getDataSourceSettingType()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "data-source-setting-type" ) );
        return OdfDataSourceSettingType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:data-source-setting-type}.
     *
     *@param  dataSourceSettingType    the attribute's type is OdfDataSourceSettingType
     */ 
     public void setDataSourceSettingType( OdfDataSourceSettingType dataSourceSettingType )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "data-source-setting-type" ), dataSourceSettingType.toString() );
    }

    /**
    * Create child element {@odfLink db:data-source-setting-value}.
    *
    *@return   return  the element {@odfLink db:data-source-setting-value}
    */
    public OdfDataSourceSettingValueElement createDataSourceSettingValueElement()
    {
        OdfDataSourceSettingValueElement  nDataSourceSettingValue = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDataSourceSettingValueElement.class);
        this.appendChild( nDataSourceSettingValue);
        return  nDataSourceSettingValue;
    }                   
               
}
