/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.db;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink db:data-source}.
 *
 */
public abstract class OdfDataSourceElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DB, "data-source" );

    /**
     * Create the instance of OdfDataSourceElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfDataSourceElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink db:data-source}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
    * Create child element {@odfLink db:connection-data}.
    *
    *@return   return  the element {@odfLink db:connection-data}
    */
    public OdfConnectionDataElement createConnectionDataElement()
    {
        OdfConnectionDataElement  nConnectionData = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfConnectionDataElement.class);
        this.appendChild( nConnectionData);
        return  nConnectionData;
    }                   
               
    /**
    * Create child element {@odfLink db:driver-settings}.
    *
    *@return   return  the element {@odfLink db:driver-settings}
    */
    public OdfDriverSettingsElement createDriverSettingsElement()
    {
        OdfDriverSettingsElement  nDriverSettings = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDriverSettingsElement.class);
        this.appendChild( nDriverSettings);
        return  nDriverSettings;
    }                   
               
    /**
    * Create child element {@odfLink db:application-connection-settings}.
    *
    *@return   return  the element {@odfLink db:application-connection-settings}
    */
    public OdfApplicationConnectionSettingsElement createApplicationConnectionSettingsElement()
    {
        OdfApplicationConnectionSettingsElement  nApplicationConnectionSettings = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfApplicationConnectionSettingsElement.class);
        this.appendChild( nApplicationConnectionSettings);
        return  nApplicationConnectionSettings;
    }                   
               
}
