/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.db;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;

import java.net.URI;
import java.net.URI;

/**
 * DOM implementation of OpenDocument element  {@odfLink db:connection-data}.
 *
 */
public abstract class OdfConnectionDataElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DB, "connection-data" );

    /**
     * Create the instance of OdfConnectionDataElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfConnectionDataElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink db:connection-data}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
    * Create child element {@odfLink db:database-description}.
    *
    *@return   return  the element {@odfLink db:database-description}
    */
    public OdfDatabaseDescriptionElement createDatabaseDescriptionElement()
    {
        OdfDatabaseDescriptionElement  nDatabaseDescription = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDatabaseDescriptionElement.class);
        this.appendChild( nDatabaseDescription);
        return  nDatabaseDescription;
    }                   
               
    /**
    * Create child element {@odfLink db:connection-resource}.
    *
    *@param href    the attribute's type is URI
    *@return   return  the element {@odfLink db:connection-resource}
    */
    public OdfConnectionResourceElement createConnectionResourceElement(org.odftoolkit.odfdom.dom.type.OdfAnyURI   href)
    {
        OdfConnectionResourceElement  nConnectionResource = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfConnectionResourceElement.class);
        nConnectionResource.setHref( href);
        this.appendChild( nConnectionResource);
        return  nConnectionResource;      
    }
    
    /**
    * Create child element {@odfLink db:compound-database}.
    *
    *@return   return  the element {@odfLink db:compound-database}
    */
    public OdfCompoundDatabaseElement createCompoundDatabaseElement()
    {
        OdfCompoundDatabaseElement  nCompoundDatabase = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCompoundDatabaseElement.class);
        this.appendChild( nCompoundDatabase);
        return  nCompoundDatabase;
    }                   
               
    /**
    * Create child element {@odfLink db:login}.
    *
    *@return   return  the element {@odfLink db:login}
    */
    public OdfLoginElement createLoginElement()
    {
        OdfLoginElement  nLogin = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfLoginElement.class);
        this.appendChild( nLogin);
        return  nLogin;
    }                   
               
}
