/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.db;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink db:component-collection}.
 *
 */
public abstract class OdfComponentCollectionElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DB, "component-collection" );

    /**
     * Create the instance of OdfComponentCollectionElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfComponentCollectionElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink db:component-collection}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfComponentCollectionElement}
     *
     *@param name  The mandatory attribute {@attributeName  db:name}" 
     *
     */
    public void init(String name)
    {
        setName( name );
    }

    /**
     * Get value of attribute {@attributeName db:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DB, "name" ) );
    }

    /**
     * Set value of attribute {@attributeName db:name}.
     *
     *@param  name    the attribute's type is String
     */ 
     public void setName( String name )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "name" ), name );
    }

    /**
     * Get value of attribute {@attributeName db:title}.
     *
     *@return return the attribute which type is String
     */
    public String getTitle()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DB, "title" ) );
    }

    /**
     * Set value of attribute {@attributeName db:title}.
     *
     *@param  title    the attribute's type is String
     */ 
     public void setTitle( String title )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "title" ), title );
    }

    /**
     * Get value of attribute {@attributeName db:description}.
     *
     *@return return the attribute which type is String
     */
    public String getDescription()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DB, "description" ) );
    }

    /**
     * Set value of attribute {@attributeName db:description}.
     *
     *@param  description    the attribute's type is String
     */ 
     public void setDescription( String description )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "description" ), description );
    }

    /**
    * Create child element {@odfLink db:component}.
    *
    *@param name String   
    *@return   return  the element {@odfLink db:component}
    */
    public OdfComponentElement createComponentElement(String   name)
    {
        OdfComponentElement  nComponent = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfComponentElement.class);
        nComponent.setName( name);
        this.appendChild( nComponent);
        return  nComponent;      
    }
    
    /**
    * Create child element {@odfLink db:component-collection}.
    *
    *@param name String   
    *@return   return  the element {@odfLink db:component-collection}
    */
    public OdfComponentCollectionElement createComponentCollectionElement(String   name)
    {
        OdfComponentCollectionElement  nComponentCollection = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfComponentCollectionElement.class);
        nComponentCollection.setName( name);
        this.appendChild( nComponentCollection);
        return  nComponentCollection;      
    }
    
}
