/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.db;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;
import org.odftoolkit.odfdom.dom.type.office.OdfValueType;
import javax.xml.datatype.XMLGregorianCalendar;
import org.odftoolkit.odfdom.dom.type.OdfDate;
import javax.xml.datatype.Duration;
import org.odftoolkit.odfdom.dom.type.OdfDuration;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink db:column}.
 *
 */
public abstract class OdfColumnElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DB, "column" );

    /**
     * Create the instance of OdfColumnElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfColumnElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink db:column}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfColumnElement}
     *
     *@param name  The mandatory attribute {@attributeName  db:name}" 
     *
     */
    public void init(String name)
    {
        setName( name );
    }

    /**
     * Get value of attribute {@attributeName db:visible}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getVisible()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "visible" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:visible}.
     *
     *@param  isVisible    the attribute's type is OdfBoolean
     */ 
     public void setVisible( OdfBoolean isVisible )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "visible" ), isVisible.toString() );
    }

    /**
     * Get value of attribute {@attributeName db:style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:style-name}.
     *
     *@param  styleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setStyleName( OdfStyleNameRef styleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "style-name" ), styleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName db:default-cell-style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getDefaultCellStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "default-cell-style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:default-cell-style-name}.
     *
     *@param  defaultCellStyleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setDefaultCellStyleName( OdfStyleNameRef defaultCellStyleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "default-cell-style-name" ), defaultCellStyleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName db:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DB, "name" ) );
    }

    /**
     * Set value of attribute {@attributeName db:name}.
     *
     *@param  name    the attribute's type is String
     */ 
     public void setName( String name )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "name" ), name );
    }

    /**
     * Get value of attribute {@attributeName db:title}.
     *
     *@return return the attribute which type is String
     */
    public String getTitle()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DB, "title" ) );
    }

    /**
     * Set value of attribute {@attributeName db:title}.
     *
     *@param  title    the attribute's type is String
     */ 
     public void setTitle( String title )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "title" ), title );
    }

    /**
     * Get value of attribute {@attributeName db:description}.
     *
     *@return return the attribute which type is String
     */
    public String getDescription()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DB, "description" ) );
    }

    /**
     * Set value of attribute {@attributeName db:description}.
     *
     *@param  description    the attribute's type is String
     */ 
     public void setDescription( String description )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "description" ), description );
    }

    /**
     * Get value of attribute {@attributeName office:value-type}.
     *
     *@return return the attribute which type is OdfValueType
     */
    public OdfValueType getValueType()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "value-type" ) );
        return OdfValueType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName office:value-type}.
     *
     *@param  valueType    the attribute's type is OdfValueType
     */ 
     public void setValueType( OdfValueType valueType )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "value-type" ), valueType.toString() );
    }

    /**
     * Get value of attribute {@attributeName office:value}.
     *
     *@return return the attribute which type is Double
     */
    public Double getValue()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "value" ) );
        return Double.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName office:value}.
     *
     *@param  value    the attribute's type is Double
     */ 
     public void setValue( Double value )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "value" ), value.toString() );
    }

    /**
     * Get value of attribute {@attributeName office:currency}.
     *
     *@return return the attribute which type is String
     */
    public String getCurrency()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "currency" ) );
    }

    /**
     * Set value of attribute {@attributeName office:currency}.
     *
     *@param  currency    the attribute's type is String
     */ 
     public void setCurrency( String currency )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "currency" ), currency );
    }

    /**
     * Get value of attribute {@attributeName office:date-value}.
     *
     *@return return the attribute which type is OdfDate
     */
    public OdfDate getDateValue()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "date-value" ) );
        return OdfDate.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName office:date-value}.
     *
     *@param  dateValue    the attribute's type is OdfDate
     */ 
     public void setDateValue( OdfDate dateValue )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "date-value" ), dateValue.toString() );
    }

    /**
     * Get value of attribute {@attributeName office:time-value}.
     *
     *@return return the attribute which type is OdfDuration
     */
    public OdfDuration getTimeValue()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "time-value" ) );
        return OdfDuration.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName office:time-value}.
     *
     *@param  timeValue    the attribute's type is OdfDuration
     */ 
     public void setTimeValue( OdfDuration timeValue )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "time-value" ), timeValue.toString() );
    }

    /**
     * Get value of attribute {@attributeName office:boolean-value}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getBooleanValue()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "boolean-value" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName office:boolean-value}.
     *
     *@param  isBooleanValue    the attribute's type is OdfBoolean
     */ 
     public void setBooleanValue( OdfBoolean isBooleanValue )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "boolean-value" ), isBooleanValue.toString() );
    }

    /**
     * Get value of attribute {@attributeName office:string-value}.
     *
     *@return return the attribute which type is String
     */
    public String getStringValue()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "string-value" ) );
    }

    /**
     * Set value of attribute {@attributeName office:string-value}.
     *
     *@param  stringValue    the attribute's type is String
     */ 
     public void setStringValue( String stringValue )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "string-value" ), stringValue );
    }

}
