/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.db;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.db.OdfDataType;
import org.odftoolkit.odfdom.dom.type.OdfPositiveInteger;
import org.odftoolkit.odfdom.dom.type.db.OdfIsNullableType;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.office.OdfValueType;
import javax.xml.datatype.XMLGregorianCalendar;
import org.odftoolkit.odfdom.dom.type.OdfDate;
import javax.xml.datatype.Duration;
import org.odftoolkit.odfdom.dom.type.OdfDuration;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink db:column-definition}.
 *
 */
public abstract class OdfColumnDefinitionElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DB, "column-definition" );

    /**
     * Create the instance of OdfColumnDefinitionElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfColumnDefinitionElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink db:column-definition}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfColumnDefinitionElement}
     *
     *@param name  The mandatory attribute {@attributeName  db:name}" 
     *
     */
    public void init(String name)
    {
        setName( name );
    }

    /**
     * Get value of attribute {@attributeName db:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DB, "name" ) );
    }

    /**
     * Set value of attribute {@attributeName db:name}.
     *
     *@param  name    the attribute's type is String
     */ 
     public void setName( String name )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "name" ), name );
    }

    /**
     * Get value of attribute {@attributeName db:data-type}.
     *
     *@return return the attribute which type is OdfDataType
     */
    public OdfDataType getDataType()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "data-type" ) );
        return OdfDataType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:data-type}.
     *
     *@param  dataType    the attribute's type is OdfDataType
     */ 
     public void setDataType( OdfDataType dataType )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "data-type" ), dataType.toString() );
    }

    /**
     * Get value of attribute {@attributeName db:type-name}.
     *
     *@return return the attribute which type is String
     */
    public String getTypeName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DB, "type-name" ) );
    }

    /**
     * Set value of attribute {@attributeName db:type-name}.
     *
     *@param  typeName    the attribute's type is String
     */ 
     public void setTypeName( String typeName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "type-name" ), typeName );
    }

    /**
     * Get value of attribute {@attributeName db:precision}.
     *
     *@return return the attribute which type is OdfPositiveInteger
     */
    public OdfPositiveInteger getPrecision()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "precision" ) );
        return OdfPositiveInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:precision}.
     *
     *@param  precision    the attribute's type is OdfPositiveInteger
     */ 
     public void setPrecision( OdfPositiveInteger precision )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "precision" ), precision.toString() );
    }

    /**
     * Get value of attribute {@attributeName db:scale}.
     *
     *@return return the attribute which type is OdfPositiveInteger
     */
    public OdfPositiveInteger getScale()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "scale" ) );
        return OdfPositiveInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:scale}.
     *
     *@param  scale    the attribute's type is OdfPositiveInteger
     */ 
     public void setScale( OdfPositiveInteger scale )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "scale" ), scale.toString() );
    }

    /**
     * Get value of attribute {@attributeName db:is-nullable}.
     *
     *@return return the attribute which type is OdfIsNullableType
     */
    public OdfIsNullableType getIsNullable()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "is-nullable" ) );
        return OdfIsNullableType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:is-nullable}.
     *
     *@param  isNullable    the attribute's type is OdfIsNullableType
     */ 
     public void setIsNullable( OdfIsNullableType isNullable )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "is-nullable" ), isNullable.toString() );
    }

    /**
     * Get value of attribute {@attributeName db:is-empty-allowed}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getIsEmptyAllowed()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "is-empty-allowed" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:is-empty-allowed}.
     *
     *@param  isIsEmptyAllowed    the attribute's type is OdfBoolean
     */ 
     public void setIsEmptyAllowed( OdfBoolean isIsEmptyAllowed )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "is-empty-allowed" ), isIsEmptyAllowed.toString() );
    }

    /**
     * Get value of attribute {@attributeName db:is-autoincrement}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getIsAutoincrement()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "is-autoincrement" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:is-autoincrement}.
     *
     *@param  isIsAutoincrement    the attribute's type is OdfBoolean
     */ 
     public void setIsAutoincrement( OdfBoolean isIsAutoincrement )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "is-autoincrement" ), isIsAutoincrement.toString() );
    }

    /**
     * Get value of attribute {@attributeName office:value-type}.
     *
     *@return return the attribute which type is OdfValueType
     */
    public OdfValueType getValueType()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "value-type" ) );
        return OdfValueType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName office:value-type}.
     *
     *@param  valueType    the attribute's type is OdfValueType
     */ 
     public void setValueType( OdfValueType valueType )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "value-type" ), valueType.toString() );
    }

    /**
     * Get value of attribute {@attributeName office:value}.
     *
     *@return return the attribute which type is Double
     */
    public Double getValue()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "value" ) );
        return Double.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName office:value}.
     *
     *@param  value    the attribute's type is Double
     */ 
     public void setValue( Double value )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "value" ), value.toString() );
    }

    /**
     * Get value of attribute {@attributeName office:currency}.
     *
     *@return return the attribute which type is String
     */
    public String getCurrency()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "currency" ) );
    }

    /**
     * Set value of attribute {@attributeName office:currency}.
     *
     *@param  currency    the attribute's type is String
     */ 
     public void setCurrency( String currency )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "currency" ), currency );
    }

    /**
     * Get value of attribute {@attributeName office:date-value}.
     *
     *@return return the attribute which type is OdfDate
     */
    public OdfDate getDateValue()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "date-value" ) );
        return OdfDate.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName office:date-value}.
     *
     *@param  dateValue    the attribute's type is OdfDate
     */ 
     public void setDateValue( OdfDate dateValue )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "date-value" ), dateValue.toString() );
    }

    /**
     * Get value of attribute {@attributeName office:time-value}.
     *
     *@return return the attribute which type is OdfDuration
     */
    public OdfDuration getTimeValue()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "time-value" ) );
        return OdfDuration.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName office:time-value}.
     *
     *@param  timeValue    the attribute's type is OdfDuration
     */ 
     public void setTimeValue( OdfDuration timeValue )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "time-value" ), timeValue.toString() );
    }

    /**
     * Get value of attribute {@attributeName office:boolean-value}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getBooleanValue()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "boolean-value" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName office:boolean-value}.
     *
     *@param  isBooleanValue    the attribute's type is OdfBoolean
     */ 
     public void setBooleanValue( OdfBoolean isBooleanValue )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "boolean-value" ), isBooleanValue.toString() );
    }

    /**
     * Get value of attribute {@attributeName office:string-value}.
     *
     *@return return the attribute which type is String
     */
    public String getStringValue()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "string-value" ) );
    }

    /**
     * Set value of attribute {@attributeName office:string-value}.
     *
     *@param  stringValue    the attribute's type is String
     */ 
     public void setStringValue( String stringValue )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "string-value" ), stringValue );
    }

}
