/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.db;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink db:auto-increment}.
 *
 */
public abstract class OdfAutoIncrementElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DB, "auto-increment" );

    /**
     * Create the instance of OdfAutoIncrementElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfAutoIncrementElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink db:auto-increment}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName db:additional-column-statement}.
     *
     *@return return the attribute which type is String
     */
    public String getAdditionalColumnStatement()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DB, "additional-column-statement" ) );
    }

    /**
     * Set value of attribute {@attributeName db:additional-column-statement}.
     *
     *@param  additionalColumnStatement    the attribute's type is String
     */ 
     public void setAdditionalColumnStatement( String additionalColumnStatement )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "additional-column-statement" ), additionalColumnStatement );
    }

    /**
     * Get value of attribute {@attributeName db:row-retrieving-statement}.
     *
     *@return return the attribute which type is String
     */
    public String getRowRetrievingStatement()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DB, "row-retrieving-statement" ) );
    }

    /**
     * Set value of attribute {@attributeName db:row-retrieving-statement}.
     *
     *@param  rowRetrievingStatement    the attribute's type is String
     */ 
     public void setRowRetrievingStatement( String rowRetrievingStatement )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "row-retrieving-statement" ), rowRetrievingStatement );
    }

}
