/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.db;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.db.OdfBooleanComparisonModeType;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink db:application-connection-settings}.
 *
 */
public abstract class OdfApplicationConnectionSettingsElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.DB, "application-connection-settings" );

    /**
     * Create the instance of OdfApplicationConnectionSettingsElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfApplicationConnectionSettingsElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink db:application-connection-settings}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName db:is-table-name-length-limited}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getIsTableNameLengthLimited()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "is-table-name-length-limited" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:is-table-name-length-limited}.
     *
     *@param  isIsTableNameLengthLimited    the attribute's type is OdfBoolean
     */ 
     public void setIsTableNameLengthLimited( OdfBoolean isIsTableNameLengthLimited )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "is-table-name-length-limited" ), isIsTableNameLengthLimited.toString() );
    }

    /**
     * Get value of attribute {@attributeName db:enable-sql92-check}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getEnableSql92Check()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "enable-sql92-check" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:enable-sql92-check}.
     *
     *@param  isEnableSql92Check    the attribute's type is OdfBoolean
     */ 
     public void setEnableSql92Check( OdfBoolean isEnableSql92Check )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "enable-sql92-check" ), isEnableSql92Check.toString() );
    }

    /**
     * Get value of attribute {@attributeName db:append-table-alias-name}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getAppendTableAliasName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "append-table-alias-name" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:append-table-alias-name}.
     *
     *@param  isAppendTableAliasName    the attribute's type is OdfBoolean
     */ 
     public void setAppendTableAliasName( OdfBoolean isAppendTableAliasName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "append-table-alias-name" ), isAppendTableAliasName.toString() );
    }

    /**
     * Get value of attribute {@attributeName db:ignore-driver-privileges}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getIgnoreDriverPrivileges()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "ignore-driver-privileges" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:ignore-driver-privileges}.
     *
     *@param  isIgnoreDriverPrivileges    the attribute's type is OdfBoolean
     */ 
     public void setIgnoreDriverPrivileges( OdfBoolean isIgnoreDriverPrivileges )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "ignore-driver-privileges" ), isIgnoreDriverPrivileges.toString() );
    }

    /**
     * Get value of attribute {@attributeName db:boolean-comparison-mode}.
     *
     *@return return the attribute which type is OdfBooleanComparisonModeType
     */
    public OdfBooleanComparisonModeType getBooleanComparisonMode()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "boolean-comparison-mode" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "equal-integer";
        }

        return OdfBooleanComparisonModeType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:boolean-comparison-mode}.
     *
     *@param  booleanComparisonMode    the attribute's type is OdfBooleanComparisonModeType
     */ 
     public void setBooleanComparisonMode( OdfBooleanComparisonModeType booleanComparisonMode )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "boolean-comparison-mode" ), booleanComparisonMode.toString() );
    }

    /**
     * Get value of attribute {@attributeName db:use-catalog}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getUseCatalog()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "use-catalog" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:use-catalog}.
     *
     *@param  isUseCatalog    the attribute's type is OdfBoolean
     */ 
     public void setUseCatalog( OdfBoolean isUseCatalog )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "use-catalog" ), isUseCatalog.toString() );
    }

    /**
     * Get value of attribute {@attributeName db:max-row-count}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getMaxRowCount()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "max-row-count" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:max-row-count}.
     *
     *@param  maxRowCount    the attribute's type is Integer
     */ 
     public void setMaxRowCount( Integer maxRowCount )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "max-row-count" ), maxRowCount.toString() );
    }

    /**
     * Get value of attribute {@attributeName db:suppress-version-columns}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getSuppressVersionColumns()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DB, "suppress-version-columns" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName db:suppress-version-columns}.
     *
     *@param  isSuppressVersionColumns    the attribute's type is OdfBoolean
     */ 
     public void setSuppressVersionColumns( OdfBoolean isSuppressVersionColumns )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DB, "suppress-version-columns" ), isSuppressVersionColumns.toString() );
    }

    /**
    * Create child element {@odfLink db:table-filter}.
    *
    *@return   return  the element {@odfLink db:table-filter}
    */
    public OdfTableFilterElement createTableFilterElement()
    {
        OdfTableFilterElement  nTableFilter = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTableFilterElement.class);
        this.appendChild( nTableFilter);
        return  nTableFilter;
    }                   
               
    /**
    * Create child element {@odfLink db:table-type-filter}.
    *
    *@return   return  the element {@odfLink db:table-type-filter}
    */
    public OdfTableTypeFilterElement createTableTypeFilterElement()
    {
        OdfTableTypeFilterElement  nTableTypeFilter = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTableTypeFilterElement.class);
        this.appendChild( nTableTypeFilter);
        return  nTableTypeFilter;
    }                   
               
    /**
    * Create child element {@odfLink db:data-source-settings}.
    *
    *@return   return  the element {@odfLink db:data-source-settings}
    */
    public OdfDataSourceSettingsElement createDataSourceSettingsElement()
    {
        OdfDataSourceSettingsElement  nDataSourceSettings = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDataSourceSettingsElement.class);
        this.appendChild( nDataSourceSettings);
        return  nDataSourceSettings;
    }                   
               
}
