/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.config;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;

import org.odftoolkit.odfdom.dom.type.config.OdfType;
import org.odftoolkit.odfdom.dom.type.config.OdfType;

/**
 * DOM implementation of OpenDocument element  {@odfLink config:config-item-map-entry}.
 *
 */
public abstract class OdfConfigItemMapEntryElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.CONFIG, "config-item-map-entry" );

    /**
     * Create the instance of OdfConfigItemMapEntryElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfConfigItemMapEntryElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink config:config-item-map-entry}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName config:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.CONFIG, "name" ) );
    }

    /**
     * Set value of attribute {@attributeName config:name}.
     *
     *@param  name    the attribute's type is String
     */ 
     public void setName( String name )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.CONFIG, "name" ), name );
    }

    /**
    * Create child element {@odfLink config:config-item}.
    *
    *@param name String   
    *@param type   the attribute's type is OdfType, see {@attributeName  config:type} at specification
    *@return   return  the element {@odfLink config:config-item}
    */
    public OdfConfigItemElement createConfigItemElement(String   name, OdfType   type)
    {
        OdfConfigItemElement  nConfigItem = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfConfigItemElement.class);
        nConfigItem.setName( name);
        nConfigItem.setType( type);
        this.appendChild( nConfigItem);
        return  nConfigItem;      
    }
    
    /**
    * Create child element {@odfLink config:config-item-set}.
    *
    *@param name String   
    *@return   return  the element {@odfLink config:config-item-set}
    */
    public OdfConfigItemSetElement createConfigItemSetElement(String   name)
    {
        OdfConfigItemSetElement  nConfigItemSet = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfConfigItemSetElement.class);
        nConfigItemSet.setName( name);
        this.appendChild( nConfigItemSet);
        return  nConfigItemSet;      
    }
    
    /**
    * Create child element {@odfLink config:config-item-map-named}.
    *
    *@param name String   
    *@return   return  the element {@odfLink config:config-item-map-named}
    */
    public OdfConfigItemMapNamedElement createConfigItemMapNamedElement(String   name)
    {
        OdfConfigItemMapNamedElement  nConfigItemMapNamed = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfConfigItemMapNamedElement.class);
        nConfigItemMapNamed.setName( name);
        this.appendChild( nConfigItemMapNamed);
        return  nConfigItemMapNamed;      
    }
    
    /**
    * Create child element {@odfLink config:config-item-map-indexed}.
    *
    *@param name String   
    *@return   return  the element {@odfLink config:config-item-map-indexed}
    */
    public OdfConfigItemMapIndexedElement createConfigItemMapIndexedElement(String   name)
    {
        OdfConfigItemMapIndexedElement  nConfigItemMapIndexed = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfConfigItemMapIndexedElement.class);
        nConfigItemMapIndexed.setName( name);
        this.appendChild( nConfigItemMapIndexed);
        return  nConfigItemMapIndexed;      
    }
    
}
