/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.config;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.config.OdfType;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink config:config-item}.
 *
 */
public abstract class OdfConfigItemElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.CONFIG, "config-item" );

    /**
     * Create the instance of OdfConfigItemElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfConfigItemElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink config:config-item}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfConfigItemElement}
     *
     *@param name  The mandatory attribute {@attributeName  config:name}" 
     *@param type  The mandatory attribute {@attributeName  config:type}" 
     *
     */
    public void init(String name, OdfType type)
    {
        setName( name );
        setType( type );
    }

    /**
     * Get value of attribute {@attributeName config:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.CONFIG, "name" ) );
    }

    /**
     * Set value of attribute {@attributeName config:name}.
     *
     *@param  name    the attribute's type is String
     */ 
     public void setName( String name )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.CONFIG, "name" ), name );
    }

    /**
     * Get value of attribute {@attributeName config:type}.
     *
     *@return return the attribute which type is OdfType
     */
    public OdfType getType()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.CONFIG, "type" ) );
        return OdfType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName config:type}.
     *
     *@param  type    the attribute's type is OdfType
     */ 
     public void setType( OdfType type )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.CONFIG, "type" ), type.toString() );
    }

}
