/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.chart;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.type.OdfCellRangeAddressList;
import org.odftoolkit.odfdom.dom.type.OdfLength;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;

import org.odftoolkit.odfdom.dom.element.text.OdfParagraphElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink chart:title}.
 *
 */
public abstract class OdfTitleElement extends OdfStylableElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.CHART, "title" );

    /**
     * Create the instance of OdfTitleElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfTitleElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME, OdfStyleFamily.Chart, OdfName.get( OdfNamespace.CHART, "style-name" ) );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink chart:title}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName table:cell-range}.
     *
     *@return return the attribute which type is OdfCellRangeAddressList
     */
    public OdfCellRangeAddressList getCellRange()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "cell-range" ) );
        return OdfCellRangeAddressList.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:cell-range}.
     *
     *@param  cellRange    the attribute's type is OdfCellRangeAddressList
     */ 
     public void setCellRange( OdfCellRangeAddressList cellRange )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "cell-range" ), cellRange.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:x}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getX()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "x" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:x}.
     *
     *@param  x    the attribute's type is OdfLength
     */ 
     public void setX( OdfLength x )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "x" ), x.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:y}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getY()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "y" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:y}.
     *
     *@param  y    the attribute's type is OdfLength
     */ 
     public void setY( OdfLength y )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "y" ), y.toString() );
    }

    /**
     * Get value of attribute {@attributeName chart:style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.CHART, "style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName chart:style-name}.
     *
     *@param  styleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setStyleName( OdfStyleNameRef styleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.CHART, "style-name" ), styleName.toString() );
    }

    /**
    * Create child element {@odfLink text:p}.
    *
    *@return   return  the element {@odfLink text:p}
    */
    public OdfParagraphElement createParagraphElement()
    {
        OdfParagraphElement  nParagraph = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfParagraphElement.class);
        this.appendChild( nParagraph);
        return  nParagraph;
    }                   
               
}
