/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.chart;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.type.OdfCellRangeAddressList;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;
import org.odftoolkit.odfdom.dom.type.OdfId;

import org.odftoolkit.odfdom.dom.type.chart.OdfDimensionType;
import org.odftoolkit.odfdom.dom.type.chart.OdfDimensionType;

/**
 * DOM implementation of OpenDocument element  {@odfLink chart:series}.
 *
 */
public abstract class OdfSeriesElement extends OdfStylableElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.CHART, "series" );

    /**
     * Create the instance of OdfSeriesElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfSeriesElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME, OdfStyleFamily.Chart, OdfName.get( OdfNamespace.CHART, "style-name" ) );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink chart:series}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName chart:values-cell-range-address}.
     *
     *@return return the attribute which type is OdfCellRangeAddressList
     */
    public OdfCellRangeAddressList getValuesCellRangeAddress()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.CHART, "values-cell-range-address" ) );
        return OdfCellRangeAddressList.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName chart:values-cell-range-address}.
     *
     *@param  valuesCellRangeAddress    the attribute's type is OdfCellRangeAddressList
     */ 
     public void setValuesCellRangeAddress( OdfCellRangeAddressList valuesCellRangeAddress )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.CHART, "values-cell-range-address" ), valuesCellRangeAddress.toString() );
    }

    /**
     * Get value of attribute {@attributeName chart:label-cell-address}.
     *
     *@return return the attribute which type is OdfCellRangeAddressList
     */
    public OdfCellRangeAddressList getLabelCellAddress()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.CHART, "label-cell-address" ) );
        return OdfCellRangeAddressList.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName chart:label-cell-address}.
     *
     *@param  labelCellAddress    the attribute's type is OdfCellRangeAddressList
     */ 
     public void setLabelCellAddress( OdfCellRangeAddressList labelCellAddress )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.CHART, "label-cell-address" ), labelCellAddress.toString() );
    }

    /**
     * Get value of attribute {@attributeName chart:class}.
     *
     *@return return the attribute which type is String
     */
    public String getChartClass()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.CHART, "class" ) );
    }

    /**
     * Set value of attribute {@attributeName chart:class}.
     *
     *@param  chartClass    the attribute's type is String
     */ 
     public void setChartClass( String chartClass )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.CHART, "class" ), chartClass );
    }

    /**
     * Get value of attribute {@attributeName chart:attached-axis}.
     *
     *@return return the attribute which type is String
     */
    public String getAttachedAxis()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.CHART, "attached-axis" ) );
    }

    /**
     * Set value of attribute {@attributeName chart:attached-axis}.
     *
     *@param  attachedAxis    the attribute's type is String
     */ 
     public void setAttachedAxis( String attachedAxis )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.CHART, "attached-axis" ), attachedAxis );
    }

    /**
     * Get value of attribute {@attributeName chart:style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.CHART, "style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName chart:style-name}.
     *
     *@param  styleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setStyleName( OdfStyleNameRef styleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.CHART, "style-name" ), styleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName xml:id}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getXmlid()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xml:id}.
     *
     *@param  xmlid    the attribute's type is OdfId
     */ 
     public void setXmlid( OdfId xmlid )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ), xmlid.toString() );
    }

    /**
    * Create child element {@odfLink chart:domain}.
    *
    *@return   return  the element {@odfLink chart:domain}
    */
    public OdfDomainElement createDomainElement()
    {
        OdfDomainElement  nDomain = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDomainElement.class);
        this.appendChild( nDomain);
        return  nDomain;
    }                   
               
    /**
    * Create child element {@odfLink chart:mean-value}.
    *
    *@return   return  the element {@odfLink chart:mean-value}
    */
    public OdfMeanValueElement createMeanValueElement()
    {
        OdfMeanValueElement  nMeanValue = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfMeanValueElement.class);
        this.appendChild( nMeanValue);
        return  nMeanValue;
    }                   
               
    /**
    * Create child element {@odfLink chart:regression-curve}.
    *
    *@return   return  the element {@odfLink chart:regression-curve}
    */
    public OdfRegressionCurveElement createRegressionCurveElement()
    {
        OdfRegressionCurveElement  nRegressionCurve = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfRegressionCurveElement.class);
        this.appendChild( nRegressionCurve);
        return  nRegressionCurve;
    }                   
               
    /**
    * Create child element {@odfLink chart:error-indicator}.
    *
    *@param dimension     the attribute's type is OdfDimensionType, see {@attributeName  chart:dimension} at specification
    *@return   return  the element {@odfLink chart:error-indicator}
    */
    public OdfErrorIndicatorElement createErrorIndicatorElement(OdfDimensionType   dimension)
    {
        OdfErrorIndicatorElement  nErrorIndicator = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfErrorIndicatorElement.class);
        nErrorIndicator.setDimension( dimension);
        this.appendChild( nErrorIndicator);
        return  nErrorIndicator;      
    }
    
    /**
    * Create child element {@odfLink chart:data-point}.
    *
    *@return   return  the element {@odfLink chart:data-point}
    */
    public OdfDataPointElement createDataPointElement()
    {
        OdfDataPointElement  nDataPoint = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDataPointElement.class);
        this.appendChild( nDataPoint);
        return  nDataPoint;
    }                   
               
    /**
    * Create child element {@odfLink chart:data-label}.
    *
    *@return   return  the element {@odfLink chart:data-label}
    */
    public OdfDataLabelElement createDataLabelElement()
    {
        OdfDataLabelElement  nDataLabel = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDataLabelElement.class);
        this.appendChild( nDataLabel);
        return  nDataLabel;
    }                   
               
}
