/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.chart;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.type.OdfLength;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;
import org.odftoolkit.odfdom.dom.type.OdfCellRangeAddressList;
import org.odftoolkit.odfdom.dom.type.chart.OdfDataSourceHasLabelsType;
import org.odftoolkit.odfdom.dom.type.dr3d.OdfProjectionType;
import org.odftoolkit.odfdom.dom.type.dr3d.OdfShadeModeType;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.OdfId;

import org.odftoolkit.odfdom.dom.element.dr3d.OdfLightElement;
import org.odftoolkit.odfdom.dom.type.chart.OdfDimensionType;

/**
 * DOM implementation of OpenDocument element  {@odfLink chart:plot-area}.
 *
 */
public abstract class OdfPlotAreaElement extends OdfStylableElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.CHART, "plot-area" );

    /**
     * Create the instance of OdfPlotAreaElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfPlotAreaElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME, OdfStyleFamily.Chart, OdfName.get( OdfNamespace.CHART, "style-name" ) );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink chart:plot-area}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName svg:x}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getX()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "x" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:x}.
     *
     *@param  x    the attribute's type is OdfLength
     */ 
     public void setX( OdfLength x )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "x" ), x.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:y}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getY()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "y" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:y}.
     *
     *@param  y    the attribute's type is OdfLength
     */ 
     public void setY( OdfLength y )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "y" ), y.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:width}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getWidth()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "width" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:width}.
     *
     *@param  width    the attribute's type is OdfLength
     */ 
     public void setWidth( OdfLength width )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "width" ), width.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:height}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getHeight()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "height" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:height}.
     *
     *@param  height    the attribute's type is OdfLength
     */ 
     public void setHeight( OdfLength height )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "height" ), height.toString() );
    }

    /**
     * Get value of attribute {@attributeName chart:style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.CHART, "style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName chart:style-name}.
     *
     *@param  styleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setStyleName( OdfStyleNameRef styleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.CHART, "style-name" ), styleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:cell-range-address}.
     *
     *@return return the attribute which type is OdfCellRangeAddressList
     */
    public OdfCellRangeAddressList getCellRangeAddress()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "cell-range-address" ) );
        return OdfCellRangeAddressList.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:cell-range-address}.
     *
     *@param  cellRangeAddress    the attribute's type is OdfCellRangeAddressList
     */ 
     public void setCellRangeAddress( OdfCellRangeAddressList cellRangeAddress )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "cell-range-address" ), cellRangeAddress.toString() );
    }

    /**
     * Get value of attribute {@attributeName chart:data-source-has-labels}.
     *
     *@return return the attribute which type is OdfDataSourceHasLabelsType
     */
    public OdfDataSourceHasLabelsType getDataSourceHasLabels()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.CHART, "data-source-has-labels" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "none";
        }

        return OdfDataSourceHasLabelsType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName chart:data-source-has-labels}.
     *
     *@param  dataSourceHasLabels    the attribute's type is OdfDataSourceHasLabelsType
     */ 
     public void setDataSourceHasLabels( OdfDataSourceHasLabelsType dataSourceHasLabels )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.CHART, "data-source-has-labels" ), dataSourceHasLabels.toString() );
    }

    /**
     * Get value of attribute {@attributeName dr3d:vrp}.
     *
     *@return return the attribute which type is String
     */
    public String getVrp()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DR3D, "vrp" ) );
    }

    /**
     * Set value of attribute {@attributeName dr3d:vrp}.
     *
     *@param  vrp    the attribute's type is String
     */ 
     public void setVrp( String vrp )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DR3D, "vrp" ), vrp );
    }

    /**
     * Get value of attribute {@attributeName dr3d:vpn}.
     *
     *@return return the attribute which type is String
     */
    public String getVpn()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DR3D, "vpn" ) );
    }

    /**
     * Set value of attribute {@attributeName dr3d:vpn}.
     *
     *@param  vpn    the attribute's type is String
     */ 
     public void setVpn( String vpn )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DR3D, "vpn" ), vpn );
    }

    /**
     * Get value of attribute {@attributeName dr3d:vup}.
     *
     *@return return the attribute which type is String
     */
    public String getVup()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DR3D, "vup" ) );
    }

    /**
     * Set value of attribute {@attributeName dr3d:vup}.
     *
     *@param  vup    the attribute's type is String
     */ 
     public void setVup( String vup )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DR3D, "vup" ), vup );
    }

    /**
     * Get value of attribute {@attributeName dr3d:projection}.
     *
     *@return return the attribute which type is OdfProjectionType
     */
    public OdfProjectionType getProjection()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DR3D, "projection" ) );
        return OdfProjectionType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName dr3d:projection}.
     *
     *@param  projection    the attribute's type is OdfProjectionType
     */ 
     public void setProjection( OdfProjectionType projection )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DR3D, "projection" ), projection.toString() );
    }

    /**
     * Get value of attribute {@attributeName dr3d:distance}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getDistance()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DR3D, "distance" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName dr3d:distance}.
     *
     *@param  distance    the attribute's type is OdfLength
     */ 
     public void setDistance( OdfLength distance )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DR3D, "distance" ), distance.toString() );
    }

    /**
     * Get value of attribute {@attributeName dr3d:focal-length}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getFocalLength()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DR3D, "focal-length" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName dr3d:focal-length}.
     *
     *@param  focalLength    the attribute's type is OdfLength
     */ 
     public void setFocalLength( OdfLength focalLength )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DR3D, "focal-length" ), focalLength.toString() );
    }

    /**
     * Get value of attribute {@attributeName dr3d:shadow-slant}.
     *
     *@return return the attribute which type is String
     */
    public String getShadowSlant()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DR3D, "shadow-slant" ) );
    }

    /**
     * Set value of attribute {@attributeName dr3d:shadow-slant}.
     *
     *@param  shadowSlant    the attribute's type is String
     */ 
     public void setShadowSlant( String shadowSlant )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DR3D, "shadow-slant" ), shadowSlant );
    }

    /**
     * Get value of attribute {@attributeName dr3d:shade-mode}.
     *
     *@return return the attribute which type is OdfShadeModeType
     */
    public OdfShadeModeType getShadeMode()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DR3D, "shade-mode" ) );
        return OdfShadeModeType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName dr3d:shade-mode}.
     *
     *@param  shadeMode    the attribute's type is OdfShadeModeType
     */ 
     public void setShadeMode( OdfShadeModeType shadeMode )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DR3D, "shade-mode" ), shadeMode.toString() );
    }

    /**
     * Get value of attribute {@attributeName dr3d:ambient-color}.
     *
     *@return return the attribute which type is String
     */
    public String getAmbientColor()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DR3D, "ambient-color" ) );
    }

    /**
     * Set value of attribute {@attributeName dr3d:ambient-color}.
     *
     *@param  ambientColor    the attribute's type is String
     */ 
     public void setAmbientColor( String ambientColor )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DR3D, "ambient-color" ), ambientColor );
    }

    /**
     * Get value of attribute {@attributeName dr3d:lighting-mode}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getLightingMode()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DR3D, "lighting-mode" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName dr3d:lighting-mode}.
     *
     *@param  isLightingMode    the attribute's type is OdfBoolean
     */ 
     public void setLightingMode( OdfBoolean isLightingMode )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DR3D, "lighting-mode" ), isLightingMode.toString() );
    }

    /**
     * Get value of attribute {@attributeName dr3d:transform}.
     *
     *@return return the attribute which type is String
     */
    public String getTransform()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DR3D, "transform" ) );
    }

    /**
     * Set value of attribute {@attributeName dr3d:transform}.
     *
     *@param  transform    the attribute's type is String
     */ 
     public void setTransform( String transform )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DR3D, "transform" ), transform );
    }

    /**
     * Get value of attribute {@attributeName xml:id}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getXmlid()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xml:id}.
     *
     *@param  xmlid    the attribute's type is OdfId
     */ 
     public void setXmlid( OdfId xmlid )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ), xmlid.toString() );
    }

    /**
    * Create child element {@odfLink dr3d:light}.
    *
    *@param direction String   
    *@return   return  the element {@odfLink dr3d:light}
    */
    public OdfLightElement createLightElement(String   direction)
    {
        OdfLightElement  nLight = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfLightElement.class);
        nLight.setDirection( direction);
        this.appendChild( nLight);
        return  nLight;      
    }
    
    /**
    * Create child element {@odfLink chart:axis}.
    *
    *@param dimension     the attribute's type is OdfDimensionType, see {@attributeName  chart:dimension} at specification
    *@return   return  the element {@odfLink chart:axis}
    */
    public OdfAxisElement createAxisElement(OdfDimensionType   dimension)
    {
        OdfAxisElement  nAxis = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfAxisElement.class);
        nAxis.setDimension( dimension);
        this.appendChild( nAxis);
        return  nAxis;      
    }
    
    /**
    * Create child element {@odfLink chart:series}.
    *
    *@return   return  the element {@odfLink chart:series}
    */
    public OdfSeriesElement createSeriesElement()
    {
        OdfSeriesElement  nSeries = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSeriesElement.class);
        this.appendChild( nSeries);
        return  nSeries;
    }                   
               
    /**
    * Create child element {@odfLink chart:stock-gain-marker}.
    *
    *@return   return  the element {@odfLink chart:stock-gain-marker}
    */
    public OdfStockGainMarkerElement createStockGainMarkerElement()
    {
        OdfStockGainMarkerElement  nStockGainMarker = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfStockGainMarkerElement.class);
        this.appendChild( nStockGainMarker);
        return  nStockGainMarker;
    }                   
               
    /**
    * Create child element {@odfLink chart:stock-loss-marker}.
    *
    *@return   return  the element {@odfLink chart:stock-loss-marker}
    */
    public OdfStockLossMarkerElement createStockLossMarkerElement()
    {
        OdfStockLossMarkerElement  nStockLossMarker = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfStockLossMarkerElement.class);
        this.appendChild( nStockLossMarker);
        return  nStockLossMarker;
    }                   
               
    /**
    * Create child element {@odfLink chart:stock-range-line}.
    *
    *@return   return  the element {@odfLink chart:stock-range-line}
    */
    public OdfStockRangeLineElement createStockRangeLineElement()
    {
        OdfStockRangeLineElement  nStockRangeLine = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfStockRangeLineElement.class);
        this.appendChild( nStockRangeLine);
        return  nStockRangeLine;
    }                   
               
    /**
    * Create child element {@odfLink chart:wall}.
    *
    *@return   return  the element {@odfLink chart:wall}
    */
    public OdfWallElement createWallElement()
    {
        OdfWallElement  nWall = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfWallElement.class);
        this.appendChild( nWall);
        return  nWall;
    }                   
               
    /**
    * Create child element {@odfLink chart:floor}.
    *
    *@return   return  the element {@odfLink chart:floor}
    */
    public OdfFloorElement createFloorElement()
    {
        OdfFloorElement  nFloor = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFloorElement.class);
        this.appendChild( nFloor);
        return  nFloor;
    }                   
               
}
