/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.chart;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.type.chart.OdfLegendPositionType;
import org.odftoolkit.odfdom.dom.type.chart.OdfLegendAlignType;
import org.odftoolkit.odfdom.dom.type.OdfLength;
import org.odftoolkit.odfdom.dom.type.style.OdfLegendExpansionType;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;

import org.odftoolkit.odfdom.dom.element.text.OdfParagraphElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink chart:legend}.
 *
 */
public abstract class OdfLegendElement extends OdfStylableElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.CHART, "legend" );

    /**
     * Create the instance of OdfLegendElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfLegendElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME, OdfStyleFamily.Chart, OdfName.get( OdfNamespace.CHART, "style-name" ) );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink chart:legend}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfLegendElement}
     *
     *@param legendPosition  The mandatory attribute {@attributeName  chart:legend-position}" 
     *@param legendExpansion  The mandatory attribute {@attributeName  style:legend-expansion}" 
     *@param legendExpansionAspectRatio  The mandatory attribute {@attributeName  style:legend-expansion-aspect-ratio}" 
     *
     */
    public void init(OdfLegendPositionType legendPosition, OdfLegendExpansionType legendExpansion, Double legendExpansionAspectRatio)
    {
        setLegendPosition( legendPosition );
        setLegendExpansion( legendExpansion );
        setLegendExpansionAspectRatio( legendExpansionAspectRatio );
    }

    /**
     * Get value of attribute {@attributeName chart:legend-position}.
     *
     *@return return the attribute which type is OdfLegendPositionType
     */
    public OdfLegendPositionType getLegendPosition()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.CHART, "legend-position" ) );
        return OdfLegendPositionType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName chart:legend-position}.
     *
     *@param  legendPosition    the attribute's type is OdfLegendPositionType
     */ 
     public void setLegendPosition( OdfLegendPositionType legendPosition )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.CHART, "legend-position" ), legendPosition.toString() );
    }

    /**
     * Get value of attribute {@attributeName chart:legend-align}.
     *
     *@return return the attribute which type is OdfLegendAlignType
     */
    public OdfLegendAlignType getLegendAlign()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.CHART, "legend-align" ) );
        return OdfLegendAlignType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName chart:legend-align}.
     *
     *@param  legendAlign    the attribute's type is OdfLegendAlignType
     */ 
     public void setLegendAlign( OdfLegendAlignType legendAlign )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.CHART, "legend-align" ), legendAlign.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:x}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getX()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "x" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:x}.
     *
     *@param  x    the attribute's type is OdfLength
     */ 
     public void setX( OdfLength x )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "x" ), x.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:y}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getY()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "y" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:y}.
     *
     *@param  y    the attribute's type is OdfLength
     */ 
     public void setY( OdfLength y )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "y" ), y.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:legend-expansion}.
     *
     *@return return the attribute which type is OdfLegendExpansionType
     */
    public OdfLegendExpansionType getLegendExpansion()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "legend-expansion" ) );
        return OdfLegendExpansionType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:legend-expansion}.
     *
     *@param  legendExpansion    the attribute's type is OdfLegendExpansionType
     */ 
     public void setLegendExpansion( OdfLegendExpansionType legendExpansion )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "legend-expansion" ), legendExpansion.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:legend-expansion-aspect-ratio}.
     *
     *@return return the attribute which type is Double
     */
    public Double getLegendExpansionAspectRatio()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "legend-expansion-aspect-ratio" ) );
        return Double.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:legend-expansion-aspect-ratio}.
     *
     *@param  legendExpansionAspectRatio    the attribute's type is Double
     */ 
     public void setLegendExpansionAspectRatio( Double legendExpansionAspectRatio )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "legend-expansion-aspect-ratio" ), legendExpansionAspectRatio.toString() );
    }

    /**
     * Get value of attribute {@attributeName chart:style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.CHART, "style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName chart:style-name}.
     *
     *@param  styleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setStyleName( OdfStyleNameRef styleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.CHART, "style-name" ), styleName.toString() );
    }

    /**
    * Create child element {@odfLink text:p}.
    *
    *@return   return  the element {@odfLink text:p}
    */
    public OdfParagraphElement createParagraphElement()
    {
        OdfParagraphElement  nParagraph = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfParagraphElement.class);
        this.appendChild( nParagraph);
        return  nParagraph;
    }                   
               
}
