/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.chart;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.type.chart.OdfClassType;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink chart:grid}.
 *
 */
public abstract class OdfGridElement extends OdfStylableElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.CHART, "grid" );

    /**
     * Create the instance of OdfGridElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfGridElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME, OdfStyleFamily.Chart, OdfName.get( OdfNamespace.CHART, "style-name" ) );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink chart:grid}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName chart:class}.
     *
     *@return return the attribute which type is OdfClassType
     */
    public OdfClassType getChartClass()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.CHART, "class" ) );
        return OdfClassType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName chart:class}.
     *
     *@param  chartClass    the attribute's type is OdfClassType
     */ 
     public void setChartClass( OdfClassType chartClass )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.CHART, "class" ), chartClass.toString() );
    }

    /**
     * Get value of attribute {@attributeName chart:style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.CHART, "style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName chart:style-name}.
     *
     *@param  styleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setStyleName( OdfStyleNameRef styleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.CHART, "style-name" ), styleName.toString() );
    }

}
