/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.chart;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;
import org.odftoolkit.odfdom.dom.type.chart.OdfDimensionType;
import org.odftoolkit.odfdom.dom.type.OdfCellRangeAddress;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink chart:error-indicator}.
 *
 */
public abstract class OdfErrorIndicatorElement extends OdfStylableElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.CHART, "error-indicator" );

    /**
     * Create the instance of OdfErrorIndicatorElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfErrorIndicatorElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME, OdfStyleFamily.Chart, OdfName.get( OdfNamespace.CHART, "style-name" ) );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink chart:error-indicator}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfErrorIndicatorElement}
     *
     *@param dimension  The mandatory attribute {@attributeName  chart:dimension}" 
     *
     */
    public void init(OdfDimensionType dimension)
    {
        setDimension( dimension );
    }

    /**
     * Get value of attribute {@attributeName chart:style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.CHART, "style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName chart:style-name}.
     *
     *@param  styleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setStyleName( OdfStyleNameRef styleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.CHART, "style-name" ), styleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName chart:dimension}.
     *
     *@return return the attribute which type is OdfDimensionType
     */
    public OdfDimensionType getDimension()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.CHART, "dimension" ) );
        return OdfDimensionType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName chart:dimension}.
     *
     *@param  dimension    the attribute's type is OdfDimensionType
     */ 
     public void setDimension( OdfDimensionType dimension )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.CHART, "dimension" ), dimension.toString() );
    }

    /**
     * Get value of attribute {@attributeName chart:error-lower-range}.
     *
     *@return return the attribute which type is OdfCellRangeAddress
     */
    public OdfCellRangeAddress getErrorLowerRange()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.CHART, "error-lower-range" ) );
        return OdfCellRangeAddress.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName chart:error-lower-range}.
     *
     *@param  errorLowerRange    the attribute's type is OdfCellRangeAddress
     */ 
     public void setErrorLowerRange( OdfCellRangeAddress errorLowerRange )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.CHART, "error-lower-range" ), errorLowerRange.toString() );
    }

    /**
     * Get value of attribute {@attributeName chart:error-upper-range}.
     *
     *@return return the attribute which type is OdfCellRangeAddress
     */
    public OdfCellRangeAddress getErrorUpperRange()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.CHART, "error-upper-range" ) );
        return OdfCellRangeAddress.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName chart:error-upper-range}.
     *
     *@param  errorUpperRange    the attribute's type is OdfCellRangeAddress
     */ 
     public void setErrorUpperRange( OdfCellRangeAddress errorUpperRange )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.CHART, "error-upper-range" ), errorUpperRange.toString() );
    }

}
