/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.chart;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.type.OdfLength;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;
import java.net.URI;
import org.odftoolkit.odfdom.dom.type.OdfAnyURI;
import org.odftoolkit.odfdom.dom.type.OdfId;

import org.odftoolkit.odfdom.dom.type.chart.OdfLegendPositionType;
import org.odftoolkit.odfdom.dom.type.style.OdfLegendExpansionType;
import org.odftoolkit.odfdom.dom.element.table.OdfTableElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink chart:chart}.
 *
 */
public abstract class OdfChartElement extends OdfStylableElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.CHART, "chart" );

    /**
     * Create the instance of OdfChartElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfChartElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME, OdfStyleFamily.Chart, OdfName.get( OdfNamespace.CHART, "style-name" ) );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink chart:chart}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfChartElement}
     *
     *@param chartClass  The mandatory attribute {@attributeName  chart:chart-class}" 
     *
     */
    public void init(String chartClass)
    {
        setChartClass( chartClass );
    }

    /**
     * Get value of attribute {@attributeName chart:class}.
     *
     *@return return the attribute which type is String
     */
    public String getChartClass()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.CHART, "class" ) );
    }

    /**
     * Set value of attribute {@attributeName chart:class}.
     *
     *@param  chartClass    the attribute's type is String
     */ 
     public void setChartClass( String chartClass )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.CHART, "class" ), chartClass );
    }

    /**
     * Get value of attribute {@attributeName svg:width}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getWidth()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "width" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:width}.
     *
     *@param  width    the attribute's type is OdfLength
     */ 
     public void setWidth( OdfLength width )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "width" ), width.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:height}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getHeight()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "height" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:height}.
     *
     *@param  height    the attribute's type is OdfLength
     */ 
     public void setHeight( OdfLength height )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "height" ), height.toString() );
    }

    /**
     * Get value of attribute {@attributeName chart:column-mapping}.
     *
     *@return return the attribute which type is String
     */
    public String getColumnMapping()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.CHART, "column-mapping" ) );
    }

    /**
     * Set value of attribute {@attributeName chart:column-mapping}.
     *
     *@param  columnMapping    the attribute's type is String
     */ 
     public void setColumnMapping( String columnMapping )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.CHART, "column-mapping" ), columnMapping );
    }

    /**
     * Get value of attribute {@attributeName chart:row-mapping}.
     *
     *@return return the attribute which type is String
     */
    public String getRowMapping()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.CHART, "row-mapping" ) );
    }

    /**
     * Set value of attribute {@attributeName chart:row-mapping}.
     *
     *@param  rowMapping    the attribute's type is String
     */ 
     public void setRowMapping( String rowMapping )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.CHART, "row-mapping" ), rowMapping );
    }

    /**
     * Get value of attribute {@attributeName chart:style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.CHART, "style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName chart:style-name}.
     *
     *@param  styleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setStyleName( OdfStyleNameRef styleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.CHART, "style-name" ), styleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName xlink:href}.
     *
     *@return return the attribute which type is OdfAnyURI
     */
    public OdfAnyURI getHref()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XLINK, "href" ) );
        return OdfAnyURI.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xlink:href}.
     *
     *@param  href    the attribute's type is OdfAnyURI
     */ 
     public void setHref( OdfAnyURI href )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "href" ), href.toString() );
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "type" ), "simple" );
    }

    /**
     * Get value of attribute {@attributeName xml:id}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getXmlid()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xml:id}.
     *
     *@param  xmlid    the attribute's type is OdfId
     */ 
     public void setXmlid( OdfId xmlid )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ), xmlid.toString() );
    }

    /**
    * Create child element {@odfLink chart:title}.
    *
    *@return   return  the element {@odfLink chart:title}
    */
    public OdfTitleElement createTitleElement()
    {
        OdfTitleElement  nTitle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTitleElement.class);
        this.appendChild( nTitle);
        return  nTitle;
    }                   
               
    /**
    * Create child element {@odfLink chart:subtitle}.
    *
    *@return   return  the element {@odfLink chart:subtitle}
    */
    public OdfSubtitleElement createSubtitleElement()
    {
        OdfSubtitleElement  nSubtitle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSubtitleElement.class);
        this.appendChild( nSubtitle);
        return  nSubtitle;
    }                   
               
    /**
    * Create child element {@odfLink chart:footer}.
    *
    *@return   return  the element {@odfLink chart:footer}
    */
    public OdfFooterElement createFooterElement()
    {
        OdfFooterElement  nFooter = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFooterElement.class);
        this.appendChild( nFooter);
        return  nFooter;
    }                   
               
    /**
    * Create child element {@odfLink chart:legend}.
    *
    *@param legendPosition     the attribute's type is OdfLegendPositionType, see {@attributeName  chart:legend-position} at specification
    *@return   return  the element {@odfLink chart:legend}
    */
    public OdfLegendElement createLegendElement(OdfLegendPositionType   legendPosition)
    {
        OdfLegendElement  nLegend = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfLegendElement.class);
        nLegend.setLegendPosition( legendPosition);
        this.appendChild( nLegend);
        return  nLegend;      
    }
    
    /**
    * Create child element {@odfLink chart:legend}.
    *
    *@param legendExpansion     the attribute's type is OdfLegendExpansionType, see {@attributeName  style:legend-expansion} at specification
    *@return   return  the element {@odfLink chart:legend}
    */
    public OdfLegendElement createLegendElement(OdfLegendExpansionType   legendExpansion)
    {
        OdfLegendElement  nLegend = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfLegendElement.class);
        nLegend.setLegendExpansion( legendExpansion);
        this.appendChild( nLegend);
        return  nLegend;      
    }
    
    /**
    * Create child element {@odfLink chart:legend}.
    *
    *@param legendExpansion   the attribute's type is OdfLegendExpansionType, see {@attributeName  style:legend-expansion} at specification
    *@param legendExpansionAspectRatio Double   
    *@return   return  the element {@odfLink chart:legend}
    */
    public OdfLegendElement createLegendElement(OdfLegendExpansionType   legendExpansion, Double   legendExpansionAspectRatio)
    {
        OdfLegendElement  nLegend = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfLegendElement.class);
        nLegend.setLegendExpansion( legendExpansion);
        nLegend.setLegendExpansionAspectRatio( legendExpansionAspectRatio);
        this.appendChild( nLegend);
        return  nLegend;      
    }
    
    /**
    * Create child element {@odfLink chart:plot-area}.
    *
    *@return   return  the element {@odfLink chart:plot-area}
    */
    public OdfPlotAreaElement createPlotAreaElement()
    {
        OdfPlotAreaElement  nPlotArea = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPlotAreaElement.class);
        this.appendChild( nPlotArea);
        return  nPlotArea;
    }                   
               
    /**
    * Create child element {@odfLink table:table}.
    *
    *@return   return  the element {@odfLink table:table}
    */
    public OdfTableElement createTableElement()
    {
        OdfTableElement  nTable = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTableElement.class);
        this.appendChild( nTable);
        return  nTable;
    }                   
               
}
