/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.anim;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfId;
import org.odftoolkit.odfdom.dom.type.smil.OdfAccumulateType;
import org.odftoolkit.odfdom.dom.type.smil.OdfAdditiveType;
import org.odftoolkit.odfdom.dom.type.smil.OdfDirectionType;
import org.odftoolkit.odfdom.dom.type.smil.OdfFadeColorType;
import org.odftoolkit.odfdom.dom.type.smil.OdfModeType;
import org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger;
import org.odftoolkit.odfdom.dom.type.smil.OdfRestartType;
import org.odftoolkit.odfdom.dom.type.smil.OdfRestartDefaultType;
import org.odftoolkit.odfdom.dom.type.smil.OdfFillType;
import org.odftoolkit.odfdom.dom.type.smil.OdfFillDefaultType;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink anim:transitionFilter}.
 *
 */
public abstract class OdfTransitionFilterElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.ANIM, "transitionFilter" );

    /**
     * Create the instance of OdfTransitionFilterElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfTransitionFilterElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink anim:transitionFilter}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfTransitionFilterElement}
     *
     *@param type  The mandatory attribute {@attributeName  smil:type}" 
     *
     */
    public void init(String type)
    {
        setType( type );
    }

    /**
     * Get value of attribute {@attributeName smil:targetElement}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getTargetElement()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "targetElement" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName smil:targetElement}.
     *
     *@param  targetElement    the attribute's type is OdfId
     */ 
     public void setTargetElement( OdfId targetElement )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "targetElement" ), targetElement.toString() );
    }

    /**
     * Get value of attribute {@attributeName anim:sub-item}.
     *
     *@return return the attribute which type is String
     */
    public String getSubItem()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.ANIM, "sub-item" ) );
    }

    /**
     * Set value of attribute {@attributeName anim:sub-item}.
     *
     *@param  subItem    the attribute's type is String
     */ 
     public void setSubItem( String subItem )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.ANIM, "sub-item" ), subItem );
    }

    /**
     * Get value of attribute {@attributeName smil:accumulate}.
     *
     *@return return the attribute which type is OdfAccumulateType
     */
    public OdfAccumulateType getAccumulate()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "accumulate" ) );
        return OdfAccumulateType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName smil:accumulate}.
     *
     *@param  accumulate    the attribute's type is OdfAccumulateType
     */ 
     public void setAccumulate( OdfAccumulateType accumulate )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "accumulate" ), accumulate.toString() );
    }

    /**
     * Get value of attribute {@attributeName smil:additive}.
     *
     *@return return the attribute which type is OdfAdditiveType
     */
    public OdfAdditiveType getAdditive()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "additive" ) );
        return OdfAdditiveType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName smil:additive}.
     *
     *@param  additive    the attribute's type is OdfAdditiveType
     */ 
     public void setAdditive( OdfAdditiveType additive )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "additive" ), additive.toString() );
    }

    /**
     * Get value of attribute {@attributeName smil:values}.
     *
     *@return return the attribute which type is String
     */
    public String getValues()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "values" ) );
    }

    /**
     * Set value of attribute {@attributeName smil:values}.
     *
     *@param  values    the attribute's type is String
     */ 
     public void setValues( String values )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "values" ), values );
    }

    /**
     * Get value of attribute {@attributeName anim:formula}.
     *
     *@return return the attribute which type is String
     */
    public String getFormula()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.ANIM, "formula" ) );
    }

    /**
     * Set value of attribute {@attributeName anim:formula}.
     *
     *@param  formula    the attribute's type is String
     */ 
     public void setFormula( String formula )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.ANIM, "formula" ), formula );
    }

    /**
     * Get value of attribute {@attributeName smil:to}.
     *
     *@return return the attribute which type is String
     */
    public String getTo()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "to" ) );
    }

    /**
     * Set value of attribute {@attributeName smil:to}.
     *
     *@param  to    the attribute's type is String
     */ 
     public void setTo( String to )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "to" ), to );
    }

    /**
     * Get value of attribute {@attributeName smil:from}.
     *
     *@return return the attribute which type is String
     */
    public String getFrom()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "from" ) );
    }

    /**
     * Set value of attribute {@attributeName smil:from}.
     *
     *@param  from    the attribute's type is String
     */ 
     public void setFrom( String from )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "from" ), from );
    }

    /**
     * Get value of attribute {@attributeName smil:by}.
     *
     *@return return the attribute which type is String
     */
    public String getBy()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "by" ) );
    }

    /**
     * Set value of attribute {@attributeName smil:by}.
     *
     *@param  by    the attribute's type is String
     */ 
     public void setBy( String by )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "by" ), by );
    }

    /**
     * Get value of attribute {@attributeName smil:type}.
     *
     *@return return the attribute which type is String
     */
    public String getType()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "type" ) );
    }

    /**
     * Set value of attribute {@attributeName smil:type}.
     *
     *@param  type    the attribute's type is String
     */ 
     public void setType( String type )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "type" ), type );
    }

    /**
     * Get value of attribute {@attributeName smil:subtype}.
     *
     *@return return the attribute which type is String
     */
    public String getSubtype()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "subtype" ) );
    }

    /**
     * Set value of attribute {@attributeName smil:subtype}.
     *
     *@param  subtype    the attribute's type is String
     */ 
     public void setSubtype( String subtype )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "subtype" ), subtype );
    }

    /**
     * Get value of attribute {@attributeName smil:direction}.
     *
     *@return return the attribute which type is OdfDirectionType
     */
    public OdfDirectionType getDirection()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "direction" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "forward";
        }

        return OdfDirectionType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName smil:direction}.
     *
     *@param  direction    the attribute's type is OdfDirectionType
     */ 
     public void setDirection( OdfDirectionType direction )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "direction" ), direction.toString() );
    }

    /**
     * Get value of attribute {@attributeName smil:fadeColor}.
     *
     *@return return the attribute which type is OdfFadeColorType
     */
    public OdfFadeColorType getFadeColor()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "fadeColor" ) );
        return OdfFadeColorType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName smil:fadeColor}.
     *
     *@param  fadeColor    the attribute's type is OdfFadeColorType
     */ 
     public void setFadeColor( OdfFadeColorType fadeColor )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "fadeColor" ), fadeColor.toString() );
    }

    /**
     * Get value of attribute {@attributeName smil:mode}.
     *
     *@return return the attribute which type is OdfModeType
     */
    public OdfModeType getMode()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "mode" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "in";
        }

        return OdfModeType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName smil:mode}.
     *
     *@param  mode    the attribute's type is OdfModeType
     */ 
     public void setMode( OdfModeType mode )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "mode" ), mode.toString() );
    }

    /**
     * Get value of attribute {@attributeName smil:begin}.
     *
     *@return return the attribute which type is String
     */
    public String getBegin()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "begin" ) );
    }

    /**
     * Set value of attribute {@attributeName smil:begin}.
     *
     *@param  begin    the attribute's type is String
     */ 
     public void setBegin( String begin )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "begin" ), begin );
    }

    /**
     * Get value of attribute {@attributeName smil:end}.
     *
     *@return return the attribute which type is String
     */
    public String getEnd()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "end" ) );
    }

    /**
     * Set value of attribute {@attributeName smil:end}.
     *
     *@param  end    the attribute's type is String
     */ 
     public void setEnd( String end )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "end" ), end );
    }

    /**
     * Get value of attribute {@attributeName smil:dur}.
     *
     *@return return the attribute which type is String
     */
    public String getDur()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "dur" ) );
    }

    /**
     * Set value of attribute {@attributeName smil:dur}.
     *
     *@param  dur    the attribute's type is String
     */ 
     public void setDur( String dur )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "dur" ), dur );
    }

    /**
     * Get value of attribute {@attributeName smil:repeatDur}.
     *
     *@return return the attribute which type is String
     */
    public String getRepeatDur()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "repeatDur" ) );
    }

    /**
     * Set value of attribute {@attributeName smil:repeatDur}.
     *
     *@param  repeatDur    the attribute's type is String
     */ 
     public void setRepeatDur( String repeatDur )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "repeatDur" ), repeatDur );
    }

    /**
     * Get value of attribute {@attributeName smil:repeatCount}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getRepeatCount()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "repeatCount" ) );
        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName smil:repeatCount}.
     *
     *@param  repeatCount    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setRepeatCount( OdfNonNegativeInteger repeatCount )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "repeatCount" ), repeatCount.toString() );
    }

    /**
     * Get value of attribute {@attributeName smil:restart}.
     *
     *@return return the attribute which type is OdfRestartType
     */
    public OdfRestartType getRestart()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "restart" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "default";
        }

        return OdfRestartType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName smil:restart}.
     *
     *@param  restart    the attribute's type is OdfRestartType
     */ 
     public void setRestart( OdfRestartType restart )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "restart" ), restart.toString() );
    }

    /**
     * Get value of attribute {@attributeName smil:restartDefault}.
     *
     *@return return the attribute which type is OdfRestartDefaultType
     */
    public OdfRestartDefaultType getRestartDefault()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "restartDefault" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "inherit";
        }

        return OdfRestartDefaultType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName smil:restartDefault}.
     *
     *@param  restartDefault    the attribute's type is OdfRestartDefaultType
     */ 
     public void setRestartDefault( OdfRestartDefaultType restartDefault )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "restartDefault" ), restartDefault.toString() );
    }

    /**
     * Get value of attribute {@attributeName smil:fill}.
     *
     *@return return the attribute which type is OdfFillType
     */
    public OdfFillType getFill()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "fill" ) );
        return OdfFillType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName smil:fill}.
     *
     *@param  fill    the attribute's type is OdfFillType
     */ 
     public void setFill( OdfFillType fill )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "fill" ), fill.toString() );
    }

    /**
     * Get value of attribute {@attributeName smil:fillDefault}.
     *
     *@return return the attribute which type is OdfFillDefaultType
     */
    public OdfFillDefaultType getFillDefault()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "fillDefault" ) );
        return OdfFillDefaultType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName smil:fillDefault}.
     *
     *@param  fillDefault    the attribute's type is OdfFillDefaultType
     */ 
     public void setFillDefault( OdfFillDefaultType fillDefault )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "fillDefault" ), fillDefault.toString() );
    }

    /**
     * Get value of attribute {@attributeName smil:accelerate}.
     *
     *@return return the attribute which type is Double
     */
    public Double getAccelerate()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "accelerate" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "0.0";
        }

        return Double.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName smil:accelerate}.
     *
     *@param  accelerate    the attribute's type is Double
     */ 
     public void setAccelerate( Double accelerate )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "accelerate" ), accelerate.toString() );
    }

    /**
     * Get value of attribute {@attributeName smil:decelerate}.
     *
     *@return return the attribute which type is Double
     */
    public Double getDecelerate()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "decelerate" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "0.0";
        }

        return Double.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName smil:decelerate}.
     *
     *@param  decelerate    the attribute's type is Double
     */ 
     public void setDecelerate( Double decelerate )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "decelerate" ), decelerate.toString() );
    }

    /**
     * Get value of attribute {@attributeName smil:autoReverse}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getAutoReverse()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "autoReverse" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName smil:autoReverse}.
     *
     *@param  isAutoReverse    the attribute's type is OdfBoolean
     */ 
     public void setAutoReverse( OdfBoolean isAutoReverse )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "autoReverse" ), isAutoReverse.toString() );
    }

}
