/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.anim;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.presentation.OdfNodeType;
import org.odftoolkit.odfdom.dom.type.presentation.OdfPresetClassType;
import org.odftoolkit.odfdom.dom.type.OdfId;
import javax.xml.datatype.Duration;
import org.odftoolkit.odfdom.dom.type.OdfDuration;
import org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger;
import org.odftoolkit.odfdom.dom.type.smil.OdfRestartType;
import org.odftoolkit.odfdom.dom.type.smil.OdfRestartDefaultType;
import org.odftoolkit.odfdom.dom.type.smil.OdfFillType;
import org.odftoolkit.odfdom.dom.type.smil.OdfFillDefaultType;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.smil.OdfEndsyncType;

import org.odftoolkit.odfdom.dom.type.svg.OdfType;
import org.odftoolkit.odfdom.dom.type.svg.OdfType;

/**
 * DOM implementation of OpenDocument element  {@odfLink anim:iterate}.
 *
 */
public abstract class OdfIterateElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.ANIM, "iterate" );

    /**
     * Create the instance of OdfIterateElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfIterateElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink anim:iterate}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName presentation:node-type}.
     *
     *@return return the attribute which type is OdfNodeType
     */
    public OdfNodeType getPresentationNode()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "node-type" ) );
        return OdfNodeType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:node-type}.
     *
     *@param  presentationNode    the attribute's type is OdfNodeType
     */ 
     public void setPresentationNode( OdfNodeType presentationNode )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "node-type" ), presentationNode.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:preset-id}.
     *
     *@return return the attribute which type is String
     */
    public String getPresetId()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "preset-id" ) );
    }

    /**
     * Set value of attribute {@attributeName presentation:preset-id}.
     *
     *@param  presetId    the attribute's type is String
     */ 
     public void setPresetId( String presetId )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "preset-id" ), presetId );
    }

    /**
     * Get value of attribute {@attributeName presentation:preset-sub-type}.
     *
     *@return return the attribute which type is String
     */
    public String getPresetSubType()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "preset-sub-type" ) );
    }

    /**
     * Set value of attribute {@attributeName presentation:preset-sub-type}.
     *
     *@param  presetSubType    the attribute's type is String
     */ 
     public void setPresetSubType( String presetSubType )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "preset-sub-type" ), presetSubType );
    }

    /**
     * Get value of attribute {@attributeName presentation:preset-class}.
     *
     *@return return the attribute which type is OdfPresetClassType
     */
    public OdfPresetClassType getPresetClass()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "preset-class" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "custom";
        }

        return OdfPresetClassType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:preset-class}.
     *
     *@param  presetClass    the attribute's type is OdfPresetClassType
     */ 
     public void setPresetClass( OdfPresetClassType presetClass )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "preset-class" ), presetClass.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:master-element}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getMasterElement()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "master-element" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:master-element}.
     *
     *@param  masterElement    the attribute's type is OdfId
     */ 
     public void setMasterElement( OdfId masterElement )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "master-element" ), masterElement.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:group-id}.
     *
     *@return return the attribute which type is String
     */
    public String getGroupId()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "group-id" ) );
    }

    /**
     * Set value of attribute {@attributeName presentation:group-id}.
     *
     *@param  groupId    the attribute's type is String
     */ 
     public void setGroupId( String groupId )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "group-id" ), groupId );
    }

    /**
     * Get value of attribute {@attributeName anim:id}.
     *
     *@return return the attribute which type is String
     */
    public String getId()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.ANIM, "id" ) );
    }

    /**
     * Set value of attribute {@attributeName anim:id}.
     *
     *@param  id    the attribute's type is String
     */ 
     public void setId( String id )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.ANIM, "id" ), id );
    }

    /**
     * Get value of attribute {@attributeName xml:id}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getXmlid()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xml:id}.
     *
     *@param  xmlid    the attribute's type is OdfId
     */ 
     public void setXmlid( OdfId xmlid )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ), xmlid.toString() );
    }

    /**
     * Get value of attribute {@attributeName smil:targetElement}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getTargetElement()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "targetElement" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName smil:targetElement}.
     *
     *@param  targetElement    the attribute's type is OdfId
     */ 
     public void setTargetElement( OdfId targetElement )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "targetElement" ), targetElement.toString() );
    }

    /**
     * Get value of attribute {@attributeName anim:sub-item}.
     *
     *@return return the attribute which type is String
     */
    public String getSubItem()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.ANIM, "sub-item" ) );
    }

    /**
     * Set value of attribute {@attributeName anim:sub-item}.
     *
     *@param  subItem    the attribute's type is String
     */ 
     public void setSubItem( String subItem )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.ANIM, "sub-item" ), subItem );
    }

    /**
     * Get value of attribute {@attributeName anim:iterate-type}.
     *
     *@return return the attribute which type is String
     */
    public String getIterateType()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.ANIM, "iterate-type" ) );
    }

    /**
     * Set value of attribute {@attributeName anim:iterate-type}.
     *
     *@param  iterateType    the attribute's type is String
     */ 
     public void setIterateType( String iterateType )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.ANIM, "iterate-type" ), iterateType );
    }

    /**
     * Get value of attribute {@attributeName anim:iterate-interval}.
     *
     *@return return the attribute which type is OdfDuration
     */
    public OdfDuration getIterateInterval()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.ANIM, "iterate-interval" ) );
        return OdfDuration.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName anim:iterate-interval}.
     *
     *@param  iterateInterval    the attribute's type is OdfDuration
     */ 
     public void setIterateInterval( OdfDuration iterateInterval )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.ANIM, "iterate-interval" ), iterateInterval.toString() );
    }

    /**
     * Get value of attribute {@attributeName smil:begin}.
     *
     *@return return the attribute which type is String
     */
    public String getBegin()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "begin" ) );
    }

    /**
     * Set value of attribute {@attributeName smil:begin}.
     *
     *@param  begin    the attribute's type is String
     */ 
     public void setBegin( String begin )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "begin" ), begin );
    }

    /**
     * Get value of attribute {@attributeName smil:end}.
     *
     *@return return the attribute which type is String
     */
    public String getEnd()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "end" ) );
    }

    /**
     * Set value of attribute {@attributeName smil:end}.
     *
     *@param  end    the attribute's type is String
     */ 
     public void setEnd( String end )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "end" ), end );
    }

    /**
     * Get value of attribute {@attributeName smil:dur}.
     *
     *@return return the attribute which type is String
     */
    public String getDur()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "dur" ) );
    }

    /**
     * Set value of attribute {@attributeName smil:dur}.
     *
     *@param  dur    the attribute's type is String
     */ 
     public void setDur( String dur )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "dur" ), dur );
    }

    /**
     * Get value of attribute {@attributeName smil:repeatDur}.
     *
     *@return return the attribute which type is String
     */
    public String getRepeatDur()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "repeatDur" ) );
    }

    /**
     * Set value of attribute {@attributeName smil:repeatDur}.
     *
     *@param  repeatDur    the attribute's type is String
     */ 
     public void setRepeatDur( String repeatDur )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "repeatDur" ), repeatDur );
    }

    /**
     * Get value of attribute {@attributeName smil:repeatCount}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getRepeatCount()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "repeatCount" ) );
        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName smil:repeatCount}.
     *
     *@param  repeatCount    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setRepeatCount( OdfNonNegativeInteger repeatCount )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "repeatCount" ), repeatCount.toString() );
    }

    /**
     * Get value of attribute {@attributeName smil:restart}.
     *
     *@return return the attribute which type is OdfRestartType
     */
    public OdfRestartType getRestart()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "restart" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "default";
        }

        return OdfRestartType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName smil:restart}.
     *
     *@param  restart    the attribute's type is OdfRestartType
     */ 
     public void setRestart( OdfRestartType restart )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "restart" ), restart.toString() );
    }

    /**
     * Get value of attribute {@attributeName smil:restartDefault}.
     *
     *@return return the attribute which type is OdfRestartDefaultType
     */
    public OdfRestartDefaultType getRestartDefault()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "restartDefault" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "inherit";
        }

        return OdfRestartDefaultType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName smil:restartDefault}.
     *
     *@param  restartDefault    the attribute's type is OdfRestartDefaultType
     */ 
     public void setRestartDefault( OdfRestartDefaultType restartDefault )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "restartDefault" ), restartDefault.toString() );
    }

    /**
     * Get value of attribute {@attributeName smil:fill}.
     *
     *@return return the attribute which type is OdfFillType
     */
    public OdfFillType getFill()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "fill" ) );
        return OdfFillType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName smil:fill}.
     *
     *@param  fill    the attribute's type is OdfFillType
     */ 
     public void setFill( OdfFillType fill )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "fill" ), fill.toString() );
    }

    /**
     * Get value of attribute {@attributeName smil:fillDefault}.
     *
     *@return return the attribute which type is OdfFillDefaultType
     */
    public OdfFillDefaultType getFillDefault()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "fillDefault" ) );
        return OdfFillDefaultType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName smil:fillDefault}.
     *
     *@param  fillDefault    the attribute's type is OdfFillDefaultType
     */ 
     public void setFillDefault( OdfFillDefaultType fillDefault )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "fillDefault" ), fillDefault.toString() );
    }

    /**
     * Get value of attribute {@attributeName smil:accelerate}.
     *
     *@return return the attribute which type is Double
     */
    public Double getAccelerate()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "accelerate" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "0.0";
        }

        return Double.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName smil:accelerate}.
     *
     *@param  accelerate    the attribute's type is Double
     */ 
     public void setAccelerate( Double accelerate )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "accelerate" ), accelerate.toString() );
    }

    /**
     * Get value of attribute {@attributeName smil:decelerate}.
     *
     *@return return the attribute which type is Double
     */
    public Double getDecelerate()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "decelerate" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "0.0";
        }

        return Double.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName smil:decelerate}.
     *
     *@param  decelerate    the attribute's type is Double
     */ 
     public void setDecelerate( Double decelerate )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "decelerate" ), decelerate.toString() );
    }

    /**
     * Get value of attribute {@attributeName smil:autoReverse}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getAutoReverse()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "autoReverse" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName smil:autoReverse}.
     *
     *@param  isAutoReverse    the attribute's type is OdfBoolean
     */ 
     public void setAutoReverse( OdfBoolean isAutoReverse )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "autoReverse" ), isAutoReverse.toString() );
    }

    /**
     * Get value of attribute {@attributeName smil:endsync}.
     *
     *@return return the attribute which type is OdfEndsyncType
     */
    public OdfEndsyncType getEndsync()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "endsync" ) );
        return OdfEndsyncType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName smil:endsync}.
     *
     *@param  endsync    the attribute's type is OdfEndsyncType
     */ 
     public void setEndsync( OdfEndsyncType endsync )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "endsync" ), endsync.toString() );
    }

    /**
    * Create child element {@odfLink anim:animate}.
    *
    *@param attributeName String   
    *@return   return  the element {@odfLink anim:animate}
    */
    public OdfAnimateElement createAnimateElement(String   attributeName)
    {
        OdfAnimateElement  nAnimate = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfAnimateElement.class);
        nAnimate.setAttributeName( attributeName);
        this.appendChild( nAnimate);
        return  nAnimate;      
    }
    
    /**
    * Create child element {@odfLink anim:set}.
    *
    *@param attributeName String   
    *@return   return  the element {@odfLink anim:set}
    */
    public OdfSetElement createSetElement(String   attributeName)
    {
        OdfSetElement  nSet = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSetElement.class);
        nSet.setAttributeName( attributeName);
        this.appendChild( nSet);
        return  nSet;      
    }
    
    /**
    * Create child element {@odfLink anim:animateMotion}.
    *
    *@param attributeName String   
    *@return   return  the element {@odfLink anim:animateMotion}
    */
    public OdfAnimateMotionElement createAnimateMotionElement(String   attributeName)
    {
        OdfAnimateMotionElement  nAnimateMotion = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfAnimateMotionElement.class);
        nAnimateMotion.setAttributeName( attributeName);
        this.appendChild( nAnimateMotion);
        return  nAnimateMotion;      
    }
    
    /**
    * Create child element {@odfLink anim:animateColor}.
    *
    *@param attributeName String   
    *@return   return  the element {@odfLink anim:animateColor}
    */
    public OdfAnimateColorElement createAnimateColorElement(String   attributeName)
    {
        OdfAnimateColorElement  nAnimateColor = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfAnimateColorElement.class);
        nAnimateColor.setAttributeName( attributeName);
        this.appendChild( nAnimateColor);
        return  nAnimateColor;      
    }
    
    /**
    * Create child element {@odfLink anim:animateTransform}.
    *
    *@param attributeName String   
    *@param type   the attribute's type is OdfType, see {@attributeName  svg:type} at specification
    *@return   return  the element {@odfLink anim:animateTransform}
    */
    public OdfAnimateTransformElement createAnimateTransformElement(String   attributeName, OdfType   type)
    {
        OdfAnimateTransformElement  nAnimateTransform = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfAnimateTransformElement.class);
        nAnimateTransform.setAttributeName( attributeName);
        nAnimateTransform.setType( type);
        this.appendChild( nAnimateTransform);
        return  nAnimateTransform;      
    }
    
    /**
    * Create child element {@odfLink anim:transitionFilter}.
    *
    *@param type String   
    *@return   return  the element {@odfLink anim:transitionFilter}
    */
    public OdfTransitionFilterElement createTransitionFilterElement(String   type)
    {
        OdfTransitionFilterElement  nTransitionFilter = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTransitionFilterElement.class);
        nTransitionFilter.setType( type);
        this.appendChild( nTransitionFilter);
        return  nTransitionFilter;      
    }
    
    /**
    * Create child element {@odfLink anim:par}.
    *
    *@return   return  the element {@odfLink anim:par}
    */
    public OdfParElement createParElement()
    {
        OdfParElement  nPar = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfParElement.class);
        this.appendChild( nPar);
        return  nPar;
    }                   
               
    /**
    * Create child element {@odfLink anim:seq}.
    *
    *@return   return  the element {@odfLink anim:seq}
    */
    public OdfSeqElement createSeqElement()
    {
        OdfSeqElement  nSeq = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSeqElement.class);
        this.appendChild( nSeq);
        return  nSeq;
    }                   
               
    /**
    * Create child element {@odfLink anim:iterate}.
    *
    *@return   return  the element {@odfLink anim:iterate}
    */
    public OdfIterateElement createIterateElement()
    {
        OdfIterateElement  nIterate = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfIterateElement.class);
        this.appendChild( nIterate);
        return  nIterate;
    }                   
               
    /**
    * Create child element {@odfLink anim:audio}.
    *
    *@return   return  the element {@odfLink anim:audio}
    */
    public OdfAudioElement createAudioElement()
    {
        OdfAudioElement  nAudio = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfAudioElement.class);
        this.appendChild( nAudio);
        return  nAudio;
    }                   
               
    /**
    * Create child element {@odfLink anim:command}.
    *
    *@param command String   
    *@return   return  the element {@odfLink anim:command}
    */
    public OdfCommandElement createCommandElement(String   command)
    {
        OdfCommandElement  nCommand = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCommandElement.class);
        nCommand.setCommand( command);
        this.appendChild( nCommand);
        return  nCommand;      
    }
    
}
