/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.anim;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.presentation.OdfNodeType;
import org.odftoolkit.odfdom.dom.type.presentation.OdfPresetClassType;
import org.odftoolkit.odfdom.dom.type.OdfId;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink anim:command}.
 *
 */
public abstract class OdfCommandElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.ANIM, "command" );

    /**
     * Create the instance of OdfCommandElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfCommandElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink anim:command}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfCommandElement}
     *
     *@param command  The mandatory attribute {@attributeName  anim:command}" 
     *
     */
    public void init(String command)
    {
        setCommand( command );
    }

    /**
     * Get value of attribute {@attributeName presentation:node-type}.
     *
     *@return return the attribute which type is OdfNodeType
     */
    public OdfNodeType getPresentationNode()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "node-type" ) );
        return OdfNodeType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:node-type}.
     *
     *@param  presentationNode    the attribute's type is OdfNodeType
     */ 
     public void setPresentationNode( OdfNodeType presentationNode )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "node-type" ), presentationNode.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:preset-id}.
     *
     *@return return the attribute which type is String
     */
    public String getPresetId()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "preset-id" ) );
    }

    /**
     * Set value of attribute {@attributeName presentation:preset-id}.
     *
     *@param  presetId    the attribute's type is String
     */ 
     public void setPresetId( String presetId )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "preset-id" ), presetId );
    }

    /**
     * Get value of attribute {@attributeName presentation:preset-sub-type}.
     *
     *@return return the attribute which type is String
     */
    public String getPresetSubType()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "preset-sub-type" ) );
    }

    /**
     * Set value of attribute {@attributeName presentation:preset-sub-type}.
     *
     *@param  presetSubType    the attribute's type is String
     */ 
     public void setPresetSubType( String presetSubType )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "preset-sub-type" ), presetSubType );
    }

    /**
     * Get value of attribute {@attributeName presentation:preset-class}.
     *
     *@return return the attribute which type is OdfPresetClassType
     */
    public OdfPresetClassType getPresetClass()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "preset-class" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "custom";
        }

        return OdfPresetClassType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:preset-class}.
     *
     *@param  presetClass    the attribute's type is OdfPresetClassType
     */ 
     public void setPresetClass( OdfPresetClassType presetClass )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "preset-class" ), presetClass.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:master-element}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getMasterElement()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "master-element" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:master-element}.
     *
     *@param  masterElement    the attribute's type is OdfId
     */ 
     public void setMasterElement( OdfId masterElement )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "master-element" ), masterElement.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:group-id}.
     *
     *@return return the attribute which type is String
     */
    public String getGroupId()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "group-id" ) );
    }

    /**
     * Set value of attribute {@attributeName presentation:group-id}.
     *
     *@param  groupId    the attribute's type is String
     */ 
     public void setGroupId( String groupId )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "group-id" ), groupId );
    }

    /**
     * Get value of attribute {@attributeName anim:id}.
     *
     *@return return the attribute which type is String
     */
    public String getId()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.ANIM, "id" ) );
    }

    /**
     * Set value of attribute {@attributeName anim:id}.
     *
     *@param  id    the attribute's type is String
     */ 
     public void setId( String id )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.ANIM, "id" ), id );
    }

    /**
     * Get value of attribute {@attributeName xml:id}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getXmlid()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xml:id}.
     *
     *@param  xmlid    the attribute's type is OdfId
     */ 
     public void setXmlid( OdfId xmlid )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ), xmlid.toString() );
    }

    /**
     * Get value of attribute {@attributeName anim:command}.
     *
     *@return return the attribute which type is String
     */
    public String getCommand()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.ANIM, "command" ) );
    }

    /**
     * Set value of attribute {@attributeName anim:command}.
     *
     *@param  command    the attribute's type is String
     */ 
     public void setCommand( String command )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.ANIM, "command" ), command );
    }

    /**
     * Get value of attribute {@attributeName smil:begin}.
     *
     *@return return the attribute which type is String
     */
    public String getBegin()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "begin" ) );
    }

    /**
     * Set value of attribute {@attributeName smil:begin}.
     *
     *@param  begin    the attribute's type is String
     */ 
     public void setBegin( String begin )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "begin" ), begin );
    }

    /**
     * Get value of attribute {@attributeName smil:end}.
     *
     *@return return the attribute which type is String
     */
    public String getEnd()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "end" ) );
    }

    /**
     * Set value of attribute {@attributeName smil:end}.
     *
     *@param  end    the attribute's type is String
     */ 
     public void setEnd( String end )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "end" ), end );
    }

    /**
     * Get value of attribute {@attributeName smil:targetElement}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getTargetElement()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "targetElement" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName smil:targetElement}.
     *
     *@param  targetElement    the attribute's type is OdfId
     */ 
     public void setTargetElement( OdfId targetElement )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "targetElement" ), targetElement.toString() );
    }

    /**
     * Get value of attribute {@attributeName anim:sub-item}.
     *
     *@return return the attribute which type is String
     */
    public String getSubItem()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.ANIM, "sub-item" ) );
    }

    /**
     * Set value of attribute {@attributeName anim:sub-item}.
     *
     *@param  subItem    the attribute's type is String
     */ 
     public void setSubItem( String subItem )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.ANIM, "sub-item" ), subItem );
    }

}
