/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.anim;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.presentation.OdfNodeType;
import org.odftoolkit.odfdom.dom.type.presentation.OdfPresetClassType;
import org.odftoolkit.odfdom.dom.type.OdfId;
import java.net.URI;
import org.odftoolkit.odfdom.dom.type.OdfAnyURI;
import org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger;
import org.odftoolkit.odfdom.dom.type.smil.OdfRestartType;
import org.odftoolkit.odfdom.dom.type.smil.OdfRestartDefaultType;
import org.odftoolkit.odfdom.dom.type.smil.OdfFillType;
import org.odftoolkit.odfdom.dom.type.smil.OdfFillDefaultType;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink anim:audio}.
 *
 */
public abstract class OdfAudioElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.ANIM, "audio" );

    /**
     * Create the instance of OdfAudioElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfAudioElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink anim:audio}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName presentation:node-type}.
     *
     *@return return the attribute which type is OdfNodeType
     */
    public OdfNodeType getPresentationNode()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "node-type" ) );
        return OdfNodeType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:node-type}.
     *
     *@param  presentationNode    the attribute's type is OdfNodeType
     */ 
     public void setPresentationNode( OdfNodeType presentationNode )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "node-type" ), presentationNode.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:preset-id}.
     *
     *@return return the attribute which type is String
     */
    public String getPresetId()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "preset-id" ) );
    }

    /**
     * Set value of attribute {@attributeName presentation:preset-id}.
     *
     *@param  presetId    the attribute's type is String
     */ 
     public void setPresetId( String presetId )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "preset-id" ), presetId );
    }

    /**
     * Get value of attribute {@attributeName presentation:preset-sub-type}.
     *
     *@return return the attribute which type is String
     */
    public String getPresetSubType()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "preset-sub-type" ) );
    }

    /**
     * Set value of attribute {@attributeName presentation:preset-sub-type}.
     *
     *@param  presetSubType    the attribute's type is String
     */ 
     public void setPresetSubType( String presetSubType )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "preset-sub-type" ), presetSubType );
    }

    /**
     * Get value of attribute {@attributeName presentation:preset-class}.
     *
     *@return return the attribute which type is OdfPresetClassType
     */
    public OdfPresetClassType getPresetClass()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "preset-class" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "custom";
        }

        return OdfPresetClassType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:preset-class}.
     *
     *@param  presetClass    the attribute's type is OdfPresetClassType
     */ 
     public void setPresetClass( OdfPresetClassType presetClass )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "preset-class" ), presetClass.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:master-element}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getMasterElement()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "master-element" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName presentation:master-element}.
     *
     *@param  masterElement    the attribute's type is OdfId
     */ 
     public void setMasterElement( OdfId masterElement )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "master-element" ), masterElement.toString() );
    }

    /**
     * Get value of attribute {@attributeName presentation:group-id}.
     *
     *@return return the attribute which type is String
     */
    public String getGroupId()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "group-id" ) );
    }

    /**
     * Set value of attribute {@attributeName presentation:group-id}.
     *
     *@param  groupId    the attribute's type is String
     */ 
     public void setGroupId( String groupId )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.PRESENTATION, "group-id" ), groupId );
    }

    /**
     * Get value of attribute {@attributeName anim:id}.
     *
     *@return return the attribute which type is String
     */
    public String getId()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.ANIM, "id" ) );
    }

    /**
     * Set value of attribute {@attributeName anim:id}.
     *
     *@param  id    the attribute's type is String
     */ 
     public void setId( String id )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.ANIM, "id" ), id );
    }

    /**
     * Get value of attribute {@attributeName xml:id}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getXmlid()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xml:id}.
     *
     *@param  xmlid    the attribute's type is OdfId
     */ 
     public void setXmlid( OdfId xmlid )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ), xmlid.toString() );
    }

    /**
     * Get value of attribute {@attributeName xlink:href}.
     *
     *@return return the attribute which type is OdfAnyURI
     */
    public OdfAnyURI getHref()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XLINK, "href" ) );
        return OdfAnyURI.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xlink:href}.
     *
     *@param  href    the attribute's type is OdfAnyURI
     */ 
     public void setHref( OdfAnyURI href )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "href" ), href.toString() );
    }

    /**
     * Get value of attribute {@attributeName anim:audio-level}.
     *
     *@return return the attribute which type is Double
     */
    public Double getAudioLevel()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.ANIM, "audio-level" ) );
        return Double.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName anim:audio-level}.
     *
     *@param  audioLevel    the attribute's type is Double
     */ 
     public void setAudioLevel( Double audioLevel )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.ANIM, "audio-level" ), audioLevel.toString() );
    }

    /**
     * Get value of attribute {@attributeName smil:begin}.
     *
     *@return return the attribute which type is String
     */
    public String getBegin()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "begin" ) );
    }

    /**
     * Set value of attribute {@attributeName smil:begin}.
     *
     *@param  begin    the attribute's type is String
     */ 
     public void setBegin( String begin )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "begin" ), begin );
    }

    /**
     * Get value of attribute {@attributeName smil:end}.
     *
     *@return return the attribute which type is String
     */
    public String getEnd()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "end" ) );
    }

    /**
     * Set value of attribute {@attributeName smil:end}.
     *
     *@param  end    the attribute's type is String
     */ 
     public void setEnd( String end )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "end" ), end );
    }

    /**
     * Get value of attribute {@attributeName smil:dur}.
     *
     *@return return the attribute which type is String
     */
    public String getDur()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "dur" ) );
    }

    /**
     * Set value of attribute {@attributeName smil:dur}.
     *
     *@param  dur    the attribute's type is String
     */ 
     public void setDur( String dur )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "dur" ), dur );
    }

    /**
     * Get value of attribute {@attributeName smil:repeatDur}.
     *
     *@return return the attribute which type is String
     */
    public String getRepeatDur()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "repeatDur" ) );
    }

    /**
     * Set value of attribute {@attributeName smil:repeatDur}.
     *
     *@param  repeatDur    the attribute's type is String
     */ 
     public void setRepeatDur( String repeatDur )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "repeatDur" ), repeatDur );
    }

    /**
     * Get value of attribute {@attributeName smil:repeatCount}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getRepeatCount()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "repeatCount" ) );
        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName smil:repeatCount}.
     *
     *@param  repeatCount    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setRepeatCount( OdfNonNegativeInteger repeatCount )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "repeatCount" ), repeatCount.toString() );
    }

    /**
     * Get value of attribute {@attributeName smil:restart}.
     *
     *@return return the attribute which type is OdfRestartType
     */
    public OdfRestartType getRestart()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "restart" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "default";
        }

        return OdfRestartType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName smil:restart}.
     *
     *@param  restart    the attribute's type is OdfRestartType
     */ 
     public void setRestart( OdfRestartType restart )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "restart" ), restart.toString() );
    }

    /**
     * Get value of attribute {@attributeName smil:restartDefault}.
     *
     *@return return the attribute which type is OdfRestartDefaultType
     */
    public OdfRestartDefaultType getRestartDefault()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "restartDefault" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "inherit";
        }

        return OdfRestartDefaultType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName smil:restartDefault}.
     *
     *@param  restartDefault    the attribute's type is OdfRestartDefaultType
     */ 
     public void setRestartDefault( OdfRestartDefaultType restartDefault )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "restartDefault" ), restartDefault.toString() );
    }

    /**
     * Get value of attribute {@attributeName smil:fill}.
     *
     *@return return the attribute which type is OdfFillType
     */
    public OdfFillType getFill()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "fill" ) );
        return OdfFillType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName smil:fill}.
     *
     *@param  fill    the attribute's type is OdfFillType
     */ 
     public void setFill( OdfFillType fill )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "fill" ), fill.toString() );
    }

    /**
     * Get value of attribute {@attributeName smil:fillDefault}.
     *
     *@return return the attribute which type is OdfFillDefaultType
     */
    public OdfFillDefaultType getFillDefault()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SMIL, "fillDefault" ) );
        return OdfFillDefaultType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName smil:fillDefault}.
     *
     *@param  fillDefault    the attribute's type is OdfFillDefaultType
     */ 
     public void setFillDefault( OdfFillDefaultType fillDefault )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SMIL, "fillDefault" ), fillDefault.toString() );
    }

}
