
/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 * 
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 * 
 * Use is subject to license terms.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

   

package org.odftoolkit.odfdom.doc.element.office;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.doc.element.draw.OdfLayerSet;
import org.odftoolkit.odfdom.doc.element.style.OdfHandoutMaster;
import org.odftoolkit.odfdom.doc.element.style.OdfMasterPage;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.element.office.OdfMasterStylesElement;
import org.w3c.dom.Node;

/**
 *
 */
public class OdfMasterStyles extends OdfMasterStylesElement
{
    
	private static final long serialVersionUID = 6598785919980862801L;
	private OdfLayerSet mLayerSet;
    private OdfHandoutMaster mHandoutMaster;
    private HashMap< String, OdfMasterPage > mMasterPages;
    
    public OdfMasterStyles( OdfFileDom _aOwnerDoc )
    {
        super( _aOwnerDoc );
    }

    public OdfHandoutMaster getHandoutMaster()
    {
        return mHandoutMaster;
    }

    public OdfLayerSet getLayerSet()
    {
        return mLayerSet;
    }
    
    public OdfMasterPage getMasterPage( String name )
    {
        if( mMasterPages != null )
            return mMasterPages.get(name);
        else
            return null;
    }

    public Iterator< OdfMasterPage > getMasterPages()
    {
        if( mMasterPages != null )
            return mMasterPages.values().iterator();
        else
            return new Vector< OdfMasterPage >().iterator();
    }            
    
    /** override this method to get notified about element insertion
     */
    @Override
	protected void onOdfNodeInserted( OdfElement node, Node refNode )
    {
        if( node instanceof OdfLayerSet )
        {
            mLayerSet = (OdfLayerSet)node;
        }
        else if( node instanceof OdfHandoutMaster )
        {
            mHandoutMaster = (OdfHandoutMaster)node;
        }
        else if( node instanceof OdfMasterPage )
        {
            OdfMasterPage masterPage = (OdfMasterPage)node;
            
            if( mMasterPages == null )
                mMasterPages = new HashMap< String, OdfMasterPage >();
            
            mMasterPages.put( masterPage.getName(), masterPage );
        }
    }
            
    /** override this method to get notified about element insertion
     */
    @Override
	protected void onOdfNodeRemoved( OdfElement node )
    {
        if( node instanceof OdfLayerSet )
        {
            if( mLayerSet == (OdfLayerSet)node )
                mLayerSet = null;
        }
        else if( node instanceof OdfHandoutMaster )
        {
            if( mHandoutMaster == (OdfHandoutMaster)node )
                mHandoutMaster = null;
        }
        else if( node instanceof OdfMasterPage )
        {
            if( mMasterPages != null )
            {
                OdfMasterPage masterPage = (OdfMasterPage)node;
                mMasterPages.remove( masterPage.getName() );            
            }
        }
    }    
}
