/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.manager.WagonConfigurationException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Site;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.CommandExecutionException;
import org.apache.maven.wagon.CommandExecutor;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.Debug;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ComponentConfigurator;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class SiteDeployMojo
extends AbstractMojo
implements Contextualizable {
    private File inputDirectory;
    private MavenProject project;
    private WagonManager wagonManager;
    private Settings settings;
    private PlexusContainer container;

    /*
     * Loose catch block
     */
    public void execute() throws MojoExecutionException {
        block23: {
            Wagon wagon;
            block22: {
                if (!this.inputDirectory.exists()) {
                    throw new MojoExecutionException("The site does not exist, please run site:site first");
                }
                DistributionManagement distributionManagement = this.project.getDistributionManagement();
                if (distributionManagement == null) {
                    throw new MojoExecutionException("Missing distribution management information in the project");
                }
                Site site = distributionManagement.getSite();
                if (site == null) {
                    throw new MojoExecutionException("Missing site information in the distribution management element in the project..");
                }
                String url = site.getUrl();
                String id = site.getId();
                if (url == null) {
                    throw new MojoExecutionException("The URL to the site is missing in the project descriptor.");
                }
                Repository repository = new Repository(id, url);
                try {
                    wagon = this.wagonManager.getWagon(repository.getProtocol());
                    SiteDeployMojo.configureWagon(wagon, repository.getId(), this.settings, this.container, this.getLog());
                }
                catch (UnsupportedProtocolException e) {
                    throw new MojoExecutionException("Unsupported protocol: '" + repository.getProtocol() + "'", (Exception)((Object)e));
                }
                catch (WagonConfigurationException e) {
                    throw new MojoExecutionException("Unable to configure Wagon: '" + repository.getProtocol() + "'", (Exception)((Object)e));
                }
                if (!wagon.supportsDirectoryCopy()) {
                    throw new MojoExecutionException("Wagon protocol '" + repository.getProtocol() + "' doesn't support directory copying");
                }
                Debug debug = new Debug();
                wagon.addSessionListener((SessionListener)debug);
                wagon.addTransferListener((TransferListener)debug);
                ProxyInfo proxyInfo = SiteDeployMojo.getProxyInfo(repository, this.wagonManager);
                if (proxyInfo != null) {
                    wagon.connect(repository, this.wagonManager.getAuthenticationInfo(id), proxyInfo);
                } else {
                    wagon.connect(repository, this.wagonManager.getAuthenticationInfo(id));
                }
                wagon.putDirectory(this.inputDirectory, ".");
                if (!(wagon instanceof CommandExecutor)) break block22;
                CommandExecutor exec = (CommandExecutor)wagon;
                exec.executeCommand("chmod -Rf g+w,a+rX " + repository.getBasedir());
            }
            Object var11_18 = null;
            try {
                wagon.disconnect();
            }
            catch (ConnectionException e) {
                this.getLog().error((CharSequence)"Error disconnecting wagon - ignored", (Throwable)e);
            }
            break block23;
            {
                catch (ResourceDoesNotExistException e) {
                    throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
                }
                catch (TransferFailedException e) {
                    throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
                }
                catch (AuthorizationException e) {
                    throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
                }
                catch (ConnectionException e) {
                    throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
                }
                catch (AuthenticationException e) {
                    throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
                }
                catch (CommandExecutionException e) {
                    throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
                }
            }
            catch (Throwable throwable) {
                Object var11_19 = null;
                try {
                    wagon.disconnect();
                }
                catch (ConnectionException e) {
                    this.getLog().error((CharSequence)"Error disconnecting wagon - ignored", (Throwable)e);
                }
                throw throwable;
            }
        }
    }

    public static ProxyInfo getProxyInfo(Repository repository, WagonManager wagonManager) {
        ProxyInfo proxyInfo = wagonManager.getProxy(repository.getProtocol());
        if (proxyInfo == null) {
            return null;
        }
        String host = repository.getHost();
        String nonProxyHostsAsString = proxyInfo.getNonProxyHosts();
        String[] nonProxyHosts = StringUtils.split((String)nonProxyHostsAsString, (String)",;|");
        for (int i = 0; i < nonProxyHosts.length; ++i) {
            String nonProxyHost = nonProxyHosts[i];
            if (StringUtils.contains((String)nonProxyHost, (String)"*")) {
                String nonProxyHostPrefix = StringUtils.substringBefore((String)nonProxyHost, (String)"*");
                String nonProxyHostSuffix = StringUtils.substringAfter((String)nonProxyHost, (String)"*");
                if (StringUtils.isNotEmpty((String)nonProxyHostPrefix) && host.startsWith(nonProxyHostPrefix) && StringUtils.isEmpty((String)nonProxyHostSuffix)) {
                    return null;
                }
                if (StringUtils.isEmpty((String)nonProxyHostPrefix) && StringUtils.isNotEmpty((String)nonProxyHostSuffix) && host.endsWith(nonProxyHostSuffix)) {
                    return null;
                }
                if (!StringUtils.isNotEmpty((String)nonProxyHostPrefix) || !host.startsWith(nonProxyHostPrefix) || !StringUtils.isNotEmpty((String)nonProxyHostSuffix) || !host.endsWith(nonProxyHostSuffix)) continue;
                return null;
            }
            if (!host.equals(nonProxyHost)) continue;
            return null;
        }
        return proxyInfo;
    }

    /*
     * Loose catch block
     */
    static void configureWagon(Wagon wagon, String repositoryId, Settings settings, PlexusContainer container, Log log) throws WagonConfigurationException {
        for (int i = 0; i < settings.getServers().size(); ++i) {
            Server server = (Server)settings.getServers().get(i);
            String id = server.getId();
            if (id == null || !id.equals(repositoryId) || server.getConfiguration() == null) continue;
            XmlPlexusConfiguration plexusConf = new XmlPlexusConfiguration((Xpp3Dom)server.getConfiguration());
            ComponentConfigurator componentConfigurator = null;
            componentConfigurator = (ComponentConfigurator)container.lookup(ComponentConfigurator.ROLE);
            componentConfigurator.configureComponent((Object)wagon, (PlexusConfiguration)plexusConf, container.getContainerRealm());
            Object var12_10 = null;
            if (componentConfigurator == null) continue;
            try {
                container.release((Object)componentConfigurator);
            }
            catch (ComponentLifecycleException e) {
                log.error((CharSequence)("Problem releasing configurator - ignoring: " + e.getMessage()));
            }
            continue;
            {
                catch (ComponentLookupException e) {
                    throw new WagonConfigurationException(repositoryId, "Unable to lookup wagon configurator. Wagon configuration cannot be applied.", (Throwable)e);
                }
                catch (ComponentConfigurationException e) {
                    throw new WagonConfigurationException(repositoryId, "Unable to apply wagon configuration.", (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                var12_10 = null;
                if (componentConfigurator != null) {
                    try {
                        container.release((Object)componentConfigurator);
                    }
                    catch (ComponentLifecycleException e) {
                        log.error((CharSequence)("Problem releasing configurator - ignoring: " + e.getMessage()));
                    }
                }
                throw throwable;
            }
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }
}

