/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVBaselineInfo;
import org.tmatesoft.svn.core.internal.io.dav.DAVCommitEditor;
import org.tmatesoft.svn.core.internal.io.dav.DAVConnection;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.DAVProperties;
import org.tmatesoft.svn.core.internal.io.dav.DAVUtil;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVDateRevisionHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVEditorHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVFileRevisionHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVLocationsHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVLogHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVProppatchHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVReplayHandler;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPStatus;
import org.tmatesoft.svn.core.internal.io.dav.http.IHTTPConnectionFactory;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNTimeUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNFileRevisionHandler;
import org.tmatesoft.svn.core.io.ISVNLocationEntryHandler;
import org.tmatesoft.svn.core.io.ISVNLockHandler;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.ISVNSession;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.core.io.SVNRepository;

class DAVRepository
extends SVNRepository {
    private DAVConnection myConnection;
    private IHTTPConnectionFactory myConnectionFactory;
    private static boolean ourIsKeepCredentials = Boolean.valueOf(System.getProperty("svnkit.http.keepCredentials", Boolean.TRUE.toString()));

    public static void setKeepCredentials(boolean keepCredentials) {
        ourIsKeepCredentials = keepCredentials;
    }

    protected DAVRepository(IHTTPConnectionFactory connectionFactory, SVNURL location, ISVNSession options) {
        super(location, options);
        this.myConnectionFactory = connectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnection() throws SVNException {
        try {
            this.openConnection();
            this.myRepositoryRoot = null;
            this.myRepositoryUUID = null;
            this.myConnection.fetchRepositoryUUID(this);
            this.myConnection.fetchRepositoryRoot(this);
        }
        finally {
            this.closeConnection();
        }
    }

    public boolean hasRepositoryUUID() {
        return this.myRepositoryUUID != null;
    }

    public void setRepositoryUUID(String uuid) {
        this.myRepositoryUUID = uuid;
    }

    public boolean hasRepositoryRoot() {
        return this.myRepositoryRoot != null;
    }

    public void setRepositoryRoot(SVNURL root) {
        this.myRepositoryRoot = root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNURL getRepositoryRoot(boolean forceConnection) throws SVNException {
        if (this.myRepositoryRoot != null && !forceConnection) {
            return this.myRepositoryRoot;
        }
        if (this.myRepositoryRoot == null) {
            try {
                this.openConnection();
                this.myConnection.fetchRepositoryRoot(this);
            }
            finally {
                this.closeConnection();
            }
        }
        return this.myRepositoryRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRepositoryUUID(boolean forceConnection) throws SVNException {
        if (this.myRepositoryUUID != null && !forceConnection) {
            return this.myRepositoryUUID;
        }
        if (this.myRepositoryUUID == null) {
            try {
                this.openConnection();
                this.myConnection.fetchRepositoryUUID(this);
            }
            finally {
                this.closeConnection();
            }
        }
        return this.myRepositoryUUID;
    }

    public void setAuthenticationManager(ISVNAuthenticationManager authManager) {
        if (authManager != this.getAuthenticationManager() && this.myConnection != null) {
            this.myConnection.clearAuthenticationCache();
        }
        super.setAuthenticationManager(authManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLatestRevision() throws SVNException {
        try {
            this.openConnection();
            String path = this.getLocation().getPath();
            path = SVNEncodingUtil.uriEncode(path);
            DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, this, path, -1L, false, true, null);
            long l = info.revision;
            return l;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDatedRevision(Date date) throws SVNException {
        date = date == null ? new Date(System.currentTimeMillis()) : date;
        DAVDateRevisionHandler handler = new DAVDateRevisionHandler();
        StringBuffer request = DAVDateRevisionHandler.generateDateRevisionRequest(null, date);
        try {
            this.openConnection();
            String path = this.getLocation().getURIEncodedPath();
            path = DAVUtil.getVCCPath(this.myConnection, this, path);
            HTTPStatus status = this.myConnection.doReport(path, request, handler);
            if (status.getError() != null) {
                if (status.getError().getErrorCode() == SVNErrorCode.UNSUPPORTED_FEATURE) {
                    SVNErrorMessage err2 = SVNErrorMessage.create(status.getError().getErrorCode(), "Server does not support date-based operations");
                    SVNErrorManager.error(err2, status.getError());
                }
                SVNErrorManager.error(status.getError());
            }
        }
        finally {
            this.closeConnection();
        }
        return handler.getRevisionNumber();
    }

    public SVNNodeKind checkPath(String path, long revision) throws SVNException {
        DAVBaselineInfo info = null;
        SVNNodeKind kind = SVNNodeKind.NONE;
        try {
            this.openConnection();
            path = this.doGetFullPath(path);
            path = SVNEncodingUtil.uriEncode(path);
            info = DAVUtil.getBaselineInfo(this.myConnection, this, path, revision, true, false, info);
            kind = info.isDirectory ? SVNNodeKind.DIR : SVNNodeKind.FILE;
        }
        catch (SVNException e) {
            SVNErrorMessage error = e.getErrorMessage();
            if (error != null) {
                if (error.getErrorCode() == SVNErrorCode.RA_DAV_PATH_NOT_FOUND) {
                    SVNNodeKind sVNNodeKind = kind;
                    return sVNNodeKind;
                }
                error = error.getChildErrorMessage();
            }
            throw e;
        }
        finally {
            this.closeConnection();
        }
        return kind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getRevisionProperties(long revision, Map properties) throws SVNException {
        properties = properties == null ? new HashMap() : properties;
        try {
            this.openConnection();
            String path = this.getLocation().getPath();
            path = SVNEncodingUtil.uriEncode(path);
            DAVProperties source = DAVUtil.getBaselineProperties(this.myConnection, this, path, revision, null);
            properties = DAVUtil.filterProperties(source, properties);
            if (revision >= 0L) {
                String commitMessage = (String)properties.get("svn:log");
                this.getOptions().saveCommitMessage(this, revision, commitMessage);
            }
        }
        finally {
            this.closeConnection();
        }
        return properties;
    }

    public String getRevisionPropertyValue(long revision, String propertyName) throws SVNException {
        Map properties = this.getRevisionProperties(revision, null);
        return (String)properties.get(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFile(String path, long revision, Map properties, OutputStream contents) throws SVNException {
        long fileRevision = revision;
        try {
            this.openConnection();
            path = this.doGetFullPath(path);
            path = SVNEncodingUtil.uriEncode(path);
            if (revision != -2L) {
                DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, this, path, revision, false, true, null);
                path = SVNPathUtil.append(info.baselineBase, info.baselinePath);
                fileRevision = info.revision;
            }
            if (properties != null) {
                DAVProperties props = DAVUtil.getResourceProperties(this.myConnection, path, null, null);
                DAVUtil.filterProperties(props, properties);
                for (DAVElement property : props.getProperties().keySet()) {
                    if (property == DAVElement.VERSION_NAME) {
                        properties.put("svn:entry:committed-rev", props.getPropertyValue(property));
                        continue;
                    }
                    if (property == DAVElement.MD5_CHECKSUM) {
                        properties.put("svn:entry:checksum", props.getPropertyValue(property));
                        continue;
                    }
                    if (property == DAVElement.CREATOR_DISPLAY_NAME) {
                        properties.put("svn:entry:last-author", props.getPropertyValue(property));
                        continue;
                    }
                    if (property != DAVElement.CREATION_DATE) continue;
                    properties.put("svn:entry:committed-date", props.getPropertyValue(property));
                }
                if (fileRevision >= 0L) {
                    properties.put("svn:entry:revision", Long.toString(fileRevision));
                }
            }
            if (contents != null) {
                this.myConnection.doGet(path, contents);
            }
        }
        finally {
            this.closeConnection();
        }
        return fileRevision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDir(String path, long revision, Map properties, ISVNDirEntryHandler handler) throws SVNException {
        long dirRevision = revision;
        try {
            this.openConnection();
            path = this.doGetFullPath(path);
            String fullPath = path = SVNEncodingUtil.uriEncode(path);
            if (revision != -2L) {
                DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, this, path, revision, false, true, null);
                path = SVNPathUtil.append(info.baselineBase, info.baselinePath);
                dirRevision = info.revision;
            }
            if (handler != null) {
                int parentPathSegments = SVNPathUtil.getSegmentsCount(path);
                HashMap dirEntsMap = new HashMap();
                HTTPStatus status = DAVUtil.getProperties(this.myConnection, path, DAVUtil.DEPTH_ONE, null, null, dirEntsMap);
                if (status.getError() != null) {
                    SVNErrorManager.error(status.getError());
                }
                for (String url : dirEntsMap.keySet()) {
                    long size;
                    DAVProperties child = (DAVProperties)dirEntsMap.get(url);
                    String href = child.getURL();
                    if (parentPathSegments == SVNPathUtil.getSegmentsCount(href)) continue;
                    String name = SVNEncodingUtil.uriDecode(SVNPathUtil.tail(href));
                    SVNNodeKind kind = SVNNodeKind.FILE;
                    String revisionStr = child.getPropertyValue(DAVElement.VERSION_NAME);
                    long lastRevision = Long.parseLong(revisionStr.toString());
                    String sizeStr = child.getPropertyValue(DAVElement.GET_CONTENT_LENGTH);
                    long l = size = sizeStr == null ? 0L : Long.parseLong(sizeStr);
                    if (child.isCollection()) {
                        kind = SVNNodeKind.DIR;
                    }
                    String author = child.getPropertyValue(DAVElement.CREATOR_DISPLAY_NAME);
                    String dateStr = child.getPropertyValue(DAVElement.CREATION_DATE);
                    Date date = dateStr != null ? SVNTimeUtil.parseDate(dateStr) : null;
                    boolean hasProperties = false;
                    for (DAVElement property : child.getProperties().keySet()) {
                        if (!"http://subversion.tigris.org/xmlns/custom/".equals(property.getNamespace()) && !"http://subversion.tigris.org/xmlns/svn/".equals(property.getNamespace())) continue;
                        hasProperties = true;
                        break;
                    }
                    SVNURL childURL = this.getLocation().setPath(fullPath, true);
                    childURL = childURL.appendPath(name, false);
                    SVNDirEntry dirEntry = new SVNDirEntry(childURL, name, kind, size, hasProperties, lastRevision, date, author);
                    handler.handleDirEntry(dirEntry);
                }
            }
            if (properties != null) {
                DAVProperties dirProps = DAVUtil.getResourceProperties(this.myConnection, path, null, null);
                DAVUtil.filterProperties(dirProps, properties);
                for (DAVElement property : dirProps.getProperties().keySet()) {
                    if (property == DAVElement.VERSION_NAME) {
                        properties.put("svn:entry:committed-rev", dirProps.getPropertyValue(property));
                        continue;
                    }
                    if (property == DAVElement.CREATOR_DISPLAY_NAME) {
                        properties.put("svn:entry:last-author", dirProps.getPropertyValue(property));
                        continue;
                    }
                    if (property != DAVElement.CREATION_DATE) continue;
                    properties.put("svn:entry:committed-date", dirProps.getPropertyValue(property));
                }
            }
        }
        finally {
            this.closeConnection();
        }
        return dirRevision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNDirEntry getDir(String path, long revision, boolean includeComments, Collection entries) throws SVNException {
        SVNDirEntry[] parent;
        block16: {
            parent = new SVNDirEntry[1];
            String[] parentVCC = new String[1];
            try {
                this.openConnection();
                path = this.doGetFullPath(path);
                String fullPath = path = SVNEncodingUtil.uriEncode(path);
                if (revision >= 0L) {
                    DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, this, path, revision, false, true, null);
                    path = SVNPathUtil.append(info.baselineBase, info.baselinePath);
                }
                int parentPathSegments = SVNPathUtil.getSegmentsCount(path);
                ArrayList<String> vccs = new ArrayList<String>();
                DAVElement[] dirProperties = new DAVElement[]{DAVElement.VERSION_CONTROLLED_CONFIGURATION, DAVElement.VERSION_NAME, DAVElement.GET_CONTENT_LENGTH, DAVElement.RESOURCE_TYPE, DAVElement.CREATOR_DISPLAY_NAME, DAVElement.CREATION_DATE};
                HashMap dirEntsMap = new HashMap();
                HTTPStatus status = DAVUtil.getProperties(this.myConnection, path, DAVUtil.DEPTH_ONE, null, dirProperties, dirEntsMap);
                if (status.getError() != null) {
                    SVNErrorManager.error(status.getError());
                }
                for (String url : dirEntsMap.keySet()) {
                    long size;
                    DAVProperties child = (DAVProperties)dirEntsMap.get(url);
                    String href = child.getURL();
                    String name = "";
                    if (parentPathSegments != SVNPathUtil.getSegmentsCount(href)) {
                        name = SVNEncodingUtil.uriDecode(SVNPathUtil.tail(href));
                    }
                    SVNNodeKind kind = SVNNodeKind.FILE;
                    String revisionStr = child.getPropertyValue(DAVElement.VERSION_NAME);
                    long lastRevision = Long.parseLong(revisionStr.toString());
                    String sizeStr = child.getPropertyValue(DAVElement.GET_CONTENT_LENGTH);
                    long l = size = sizeStr == null ? 0L : Long.parseLong(sizeStr);
                    if (child.isCollection()) {
                        kind = SVNNodeKind.DIR;
                    }
                    String author = child.getPropertyValue(DAVElement.CREATOR_DISPLAY_NAME);
                    String dateStr = child.getPropertyValue(DAVElement.CREATION_DATE);
                    Date date = dateStr != null ? SVNTimeUtil.parseDate(dateStr) : null;
                    SVNURL childURL = this.getLocation().setPath(fullPath, true);
                    if ("".equals(name)) {
                        parent[0] = new SVNDirEntry(childURL, name, kind, size, false, lastRevision, date, author);
                        parentVCC[0] = child.getPropertyValue(DAVElement.VERSION_CONTROLLED_CONFIGURATION);
                        continue;
                    }
                    childURL = childURL.appendPath(name, false);
                    entries.add(new SVNDirEntry(childURL, name, kind, size, false, lastRevision, date, author));
                    vccs.add(child.getPropertyValue(DAVElement.VERSION_CONTROLLED_CONFIGURATION));
                }
                if (!includeComments) break block16;
                DAVElement logProperty = DAVElement.getElement("http://subversion.tigris.org/xmlns/svn/", "log");
                Iterator ents = entries.iterator();
                SVNDirEntry entry = parent[0];
                String vcc = parentVCC[0];
                int index = 0;
                while (true) {
                    String label = Long.toString(entry.getRevision());
                    if (entry.getDate() != null && this.getOptions().hasCommitMessage(this, entry.getRevision())) {
                        String message = this.getOptions().getCommitMessage(this, entry.getRevision());
                        entry.setCommitMessage(message);
                    } else if (entry.getDate() != null) {
                        String commitMessage;
                        SVNDirEntry currentEntry;
                        block17: {
                            currentEntry = entry;
                            commitMessage = null;
                            try {
                                commitMessage = DAVUtil.getPropertyValue(this.myConnection, vcc, label, logProperty);
                            }
                            catch (SVNException e) {
                                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_DAV_PROPS_NOT_FOUND) break block17;
                                throw e;
                            }
                        }
                        this.getOptions().saveCommitMessage(this, currentEntry.getRevision(), commitMessage);
                        currentEntry.setCommitMessage(commitMessage);
                    }
                    if (ents.hasNext()) {
                        entry = (SVNDirEntry)ents.next();
                        vcc = (String)vccs.get(index);
                        ++index;
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.closeConnection();
            }
        }
        return parent[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFileRevisions(String path, long startRevision, long endRevision, ISVNFileRevisionHandler handler) throws SVNException {
        String bcPath = this.getLocation().getPath();
        bcPath = SVNEncodingUtil.uriEncode(bcPath);
        try {
            SVNErrorMessage err;
            this.openConnection();
            path = "".equals(path) ? "" : this.doGetRepositoryPath(path);
            DAVFileRevisionHandler davHandler = new DAVFileRevisionHandler(handler);
            StringBuffer request = DAVFileRevisionHandler.generateFileRevisionsRequest(null, startRevision, endRevision, path);
            long revision = -1L;
            if (DAVRepository.isValidRevision(startRevision) && DAVRepository.isValidRevision(endRevision)) {
                revision = Math.max(startRevision, endRevision);
            }
            DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, this, bcPath, revision, false, false, null);
            bcPath = SVNPathUtil.append(info.baselineBase, info.baselinePath);
            HTTPStatus status = this.myConnection.doReport(bcPath, request, davHandler);
            if (status.getCode() == 501) {
                err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, "'get-file-revs' REPORT not implemented");
                SVNErrorManager.error(err, status.getError());
            } else if (status.getError() != null) {
                SVNErrorManager.error(status.getError());
            }
            if (davHandler.getEntriesCount() <= 0) {
                err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "The file-revs report didn't contain any revisions");
                SVNErrorManager.error(err);
            }
            int n = davHandler.getEntriesCount();
            return n;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long log(String[] targetPaths, long startRevision, long endRevision, boolean changedPath, boolean strictNode, long limit, final ISVNLogEntryHandler handler) throws SVNException {
        if (targetPaths == null || targetPaths.length == 0) {
            targetPaths = new String[]{""};
        }
        DAVLogHandler davHandler = null;
        ISVNLogEntryHandler cachingHandler = new ISVNLogEntryHandler(){

            public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                if (logEntry.getDate() != null) {
                    DAVRepository.this.getOptions().saveCommitMessage(DAVRepository.this, logEntry.getRevision(), logEntry.getMessage());
                }
                handler.handleLogEntry(logEntry);
            }
        };
        long latestRev = -1L;
        if (DAVRepository.isInvalidRevision(startRevision)) {
            startRevision = latestRev = this.getLatestRevision();
        }
        if (DAVRepository.isInvalidRevision(endRevision)) {
            endRevision = latestRev != -1L ? latestRev : this.getLatestRevision();
        }
        try {
            this.openConnection();
            String[] fullPaths = new String[targetPaths.length];
            for (int i = 0; i < targetPaths.length; ++i) {
                fullPaths[i] = this.doGetFullPath(targetPaths[i]);
            }
            HashSet<String> relativePaths = new HashSet<String>();
            String path = SVNPathUtil.condencePaths(fullPaths, relativePaths, false);
            if (relativePaths.isEmpty()) {
                relativePaths.add("");
            }
            fullPaths = relativePaths.toArray(new String[relativePaths.size()]);
            StringBuffer request = DAVLogHandler.generateLogRequest(null, startRevision, endRevision, changedPath, strictNode, limit, fullPaths);
            davHandler = new DAVLogHandler(cachingHandler, limit);
            long revision = Math.max(startRevision, endRevision);
            path = SVNEncodingUtil.uriEncode(path);
            DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, this, path, revision, false, false, null);
            path = SVNPathUtil.append(info.baselineBase, info.baselinePath);
            HTTPStatus status = this.myConnection.doReport(path, request, davHandler);
            if (status.getError() != null && !davHandler.isCompatibleMode()) {
                SVNErrorManager.error(status.getError());
            }
        }
        finally {
            this.closeConnection();
        }
        return davHandler.getEntriesCount();
    }

    protected void openConnection() throws SVNException {
        this.lock();
        this.fireConnectionOpened();
        if (this.myConnection == null) {
            this.myConnection = new DAVConnection(this.myConnectionFactory, this);
            this.myConnection.open(this);
        }
    }

    protected void closeConnection() {
        if (this.myConnection != null && !ourIsKeepCredentials) {
            this.myConnection.clearAuthenticationCache();
        }
        if (!this.getOptions().keepConnection(this)) {
            this.closeSession();
        }
        this.unlock();
        this.fireConnectionClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLocations(String path, long pegRevision, long[] revisions, ISVNLocationEntryHandler handler) throws SVNException {
        try {
            this.openConnection();
            if (path.startsWith("/")) {
                this.myConnection.fetchRepositoryRoot(this);
                path = SVNPathUtil.append(this.myRepositoryRoot.getPath(), path);
                path = path.equals(this.getLocation().getPath()) ? "" : path.substring(this.getLocation().getPath().length() + 1);
            }
            StringBuffer request = DAVLocationsHandler.generateLocationsRequest(null, path, pegRevision, revisions);
            DAVLocationsHandler davHandler = new DAVLocationsHandler(handler);
            String root = this.getLocation().getPath();
            root = SVNEncodingUtil.uriEncode(root);
            DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, this, root, pegRevision, false, false, null);
            path = SVNPathUtil.append(info.baselineBase, info.baselinePath);
            HTTPStatus status = this.myConnection.doReport(path, request, davHandler);
            if (status.getCode() == 501) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, "'get-locations' REPORT not implemented");
                SVNErrorManager.error(err, status.getError());
            } else if (status.getError() != null) {
                SVNErrorManager.error(status.getError());
            }
            int n = davHandler.getEntriesCount();
            return n;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replay(long lowRevision, long highRevision, boolean sendDeltas, ISVNEditor editor) throws SVNException {
        try {
            this.openConnection();
            StringBuffer request = DAVReplayHandler.generateReplayRequest(highRevision, lowRevision, sendDeltas);
            DAVReplayHandler handler = new DAVReplayHandler(editor, true);
            String bcPath = SVNEncodingUtil.uriEncode(this.getLocation().getPath());
            bcPath = DAVUtil.getVCCPath(this.myConnection, this, bcPath);
            HTTPStatus status = this.myConnection.doReport(bcPath, request, handler);
            if (status.getCode() == 501) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, "'replay' REPORT not implemented");
                SVNErrorManager.error(err, status.getError());
            } else if (status.getError() != null) {
                SVNErrorManager.error(status.getError());
            }
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(long revision, String target, boolean recursive, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        try {
            this.openConnection();
            StringBuffer request = DAVEditorHandler.generateEditorRequest(this.myConnection, null, this.getLocation().toString(), revision, target, null, recursive, false, false, true, reporter);
            DAVEditorHandler handler = new DAVEditorHandler(editor, true);
            String bcPath = SVNEncodingUtil.uriEncode(this.getLocation().getPath());
            bcPath = DAVUtil.getVCCPath(this.myConnection, this, bcPath);
            HTTPStatus status = this.myConnection.doReport(bcPath, request, handler);
            if (status.getError() != null) {
                SVNErrorManager.error(status.getError());
            }
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(SVNURL url, long revision, String target, boolean recursive, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        if (url == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL could not be NULL");
            SVNErrorManager.error(err);
        }
        try {
            this.openConnection();
            StringBuffer request = DAVEditorHandler.generateEditorRequest(this.myConnection, null, this.getLocation().toString(), revision, target, url.toString(), recursive, true, false, true, reporter);
            DAVEditorHandler handler = new DAVEditorHandler(editor, true);
            String bcPath = SVNEncodingUtil.uriEncode(this.getLocation().getPath());
            try {
                bcPath = DAVUtil.getVCCPath(this.myConnection, this, bcPath);
            }
            catch (SVNException e) {
                editor.closeEdit();
                throw e;
            }
            HTTPStatus status = this.myConnection.doReport(bcPath, request, handler);
            if (status.getError() != null) {
                SVNErrorManager.error(status.getError());
            }
        }
        finally {
            this.closeConnection();
        }
    }

    public void diff(SVNURL url, long revision, String target, boolean ignoreAncestry, boolean recursive, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        this.diff(url, revision, revision, target, ignoreAncestry, recursive, reporter, editor);
    }

    public void diff(SVNURL url, long targetRevision, long revision, String target, boolean ignoreAncestry, boolean recursive, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        this.diff(url, revision, revision, target, ignoreAncestry, recursive, true, reporter, editor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void diff(SVNURL url, long targetRevision, long revision, String target, boolean ignoreAncestry, boolean recursive, boolean getContents, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        if (url == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL could not be NULL");
            SVNErrorManager.error(err);
        }
        if (revision < 0L) {
            revision = targetRevision;
        }
        try {
            this.openConnection();
            StringBuffer request = DAVEditorHandler.generateEditorRequest(this.myConnection, null, this.getLocation().toString(), targetRevision, target, url.toString(), recursive, ignoreAncestry, false, getContents, reporter);
            DAVEditorHandler handler = new DAVEditorHandler(editor, true);
            String path = SVNEncodingUtil.uriEncode(this.getLocation().getPath());
            path = DAVUtil.getVCCPath(this.myConnection, this, path);
            HTTPStatus status = this.myConnection.doReport(path, request, handler, true);
            if (status.getError() != null) {
                SVNErrorManager.error(status.getError());
            }
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void status(long revision, String target, boolean recursive, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        try {
            this.openConnection();
            StringBuffer request = DAVEditorHandler.generateEditorRequest(this.myConnection, null, this.getLocation().toString(), revision, target, null, recursive, false, false, false, reporter);
            DAVEditorHandler handler = new DAVEditorHandler(editor, false);
            String path = SVNEncodingUtil.uriEncode(this.getLocation().getPath());
            path = DAVUtil.getVCCPath(this.myConnection, this, path);
            HTTPStatus status = this.myConnection.doReport(path, request, handler);
            if (status.getError() != null) {
                SVNErrorManager.error(status.getError());
            }
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRevisionPropertyValue(long revision, String propertyName, String propertyValue) throws SVNException {
        DAVRepository.assertValidRevision(revision);
        StringBuffer request = DAVProppatchHandler.generatePropertyRequest(null, propertyName, propertyValue);
        try {
            this.openConnection();
            DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, this, SVNEncodingUtil.uriEncode(this.getLocation().getPath()), revision, false, false, null);
            String path = SVNPathUtil.append(info.baselineBase, info.baselinePath);
            path = info.baseline;
            try {
                this.myConnection.doProppatch(null, path, request, null, null);
            }
            catch (SVNException e) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "DAV request failed; it's possible that the repository's pre-rev-propchange hook either failed or is non-existent");
                SVNErrorManager.error(err, e.getErrorMessage());
            }
        }
        finally {
            this.closeConnection();
        }
    }

    public ISVNEditor getCommitEditor(String logMessage, Map locks, boolean keepLocks, ISVNWorkspaceMediator mediator) throws SVNException {
        try {
            this.openConnection();
            HashMap<String, String> translatedLocks = null;
            if (locks != null) {
                translatedLocks = new HashMap<String, String>(locks.size());
                this.myConnection.fetchRepositoryRoot(this);
                String root = this.myRepositoryRoot.getPath();
                root = SVNEncodingUtil.uriEncode(root);
                for (String path : locks.keySet()) {
                    String lock = (String)locks.get(path);
                    if (path.startsWith("/")) {
                        path = SVNPathUtil.append(root, SVNEncodingUtil.uriEncode(path));
                    } else {
                        path = this.doGetFullPath(path);
                        path = SVNEncodingUtil.uriEncode(path);
                    }
                    translatedLocks.put(path, lock);
                }
            }
            this.myConnection.setLocks(translatedLocks, keepLocks);
            return new DAVCommitEditor(this, this.myConnection, logMessage, mediator, new Runnable(){

                public void run() {
                    DAVRepository.this.closeConnection();
                }
            });
        }
        catch (Throwable th) {
            this.closeConnection();
            if (th instanceof SVNException) {
                throw (SVNException)th;
            }
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "can not get commit editor: ''{0}''", th.getLocalizedMessage());
            SVNErrorManager.error(err, th);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNLock getLock(String path) throws SVNException {
        try {
            this.openConnection();
            path = this.doGetFullPath(path);
            path = SVNEncodingUtil.uriEncode(path);
            SVNLock sVNLock = this.myConnection.doGetLock(path, this);
            return sVNLock;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNLock[] getLocks(String path) throws SVNException {
        try {
            this.openConnection();
            path = this.doGetFullPath(path);
            path = SVNEncodingUtil.uriEncode(path);
            SVNLock[] sVNLockArray = this.myConnection.doGetLocks(path);
            return sVNLockArray;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Map pathsToRevisions, String comment, boolean force, ISVNLockHandler handler) throws SVNException {
        try {
            this.openConnection();
            for (String path : pathsToRevisions.keySet()) {
                SVNErrorMessage error;
                SVNLock lock;
                String repositoryPath;
                block7: {
                    Long revision = (Long)pathsToRevisions.get(path);
                    repositoryPath = this.doGetRepositoryPath(path);
                    path = this.doGetFullPath(path);
                    path = SVNEncodingUtil.uriEncode(path);
                    lock = null;
                    error = null;
                    long revisionNumber = revision != null ? revision : -1L;
                    try {
                        lock = this.myConnection.doLock(path, this, comment, force, revisionNumber);
                    }
                    catch (SVNException e) {
                        SVNErrorCode code;
                        error = null;
                        if (e.getErrorMessage() != null && ((code = e.getErrorMessage().getErrorCode()) == SVNErrorCode.FS_PATH_ALREADY_LOCKED || code == SVNErrorCode.FS_OUT_OF_DATE)) {
                            error = e.getErrorMessage();
                        }
                        if (error != null) break block7;
                        throw e;
                    }
                }
                if (handler == null) continue;
                handler.handleLock(repositoryPath, lock, error);
            }
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Map pathToTokens, boolean force, ISVNLockHandler handler) throws SVNException {
        try {
            this.openConnection();
            Iterator paths = pathToTokens.keySet().iterator();
            while (paths.hasNext()) {
                String path;
                String shortPath = path = (String)paths.next();
                String id = (String)pathToTokens.get(path);
                String repositoryPath = this.doGetRepositoryPath(path);
                path = this.doGetFullPath(path);
                path = SVNEncodingUtil.uriEncode(path);
                SVNErrorMessage error = null;
                try {
                    this.myConnection.doUnlock(path, this, id, force);
                    error = null;
                }
                catch (SVNException e) {
                    if (e.getErrorMessage() != null && e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NOT_LOCKED) {
                        error = e.getErrorMessage();
                        error = SVNErrorMessage.create(error.getErrorCode(), error.getMessageTemplate(), shortPath);
                    }
                    throw e;
                }
                if (handler == null) continue;
                handler.handleUnlock(repositoryPath, new SVNLock(path, id, null, null, null, null), error);
            }
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SVNDirEntry info(String path, long revision) throws SVNException {
        try {
            HashMap propsMap;
            DAVElement[] elements;
            HTTPStatus status;
            this.openConnection();
            path = this.doGetFullPath(path);
            String fullPath = path = SVNEncodingUtil.uriEncode(path);
            if (revision >= 0L) {
                try {
                    DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, this, path, revision, false, true, null);
                    path = SVNPathUtil.append(info.baselineBase, info.baselinePath);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage() == null) throw e;
                    if (e.getErrorMessage().getErrorCode() != SVNErrorCode.RA_DAV_PATH_NOT_FOUND) throw e;
                    SVNDirEntry sVNDirEntry = null;
                    this.closeConnection();
                    return sVNDirEntry;
                }
            }
            if ((status = DAVUtil.getProperties(this.myConnection, path, 0, null, elements = null, propsMap = new HashMap())).getError() != null) {
                if (status.getError().getErrorCode() == SVNErrorCode.RA_DAV_PATH_NOT_FOUND) {
                    SVNDirEntry sVNDirEntry = null;
                    return sVNDirEntry;
                }
                SVNErrorManager.error(status.getError());
            }
            if (propsMap.isEmpty()) return null;
            DAVProperties props = (DAVProperties)propsMap.values().iterator().next();
            SVNDirEntry sVNDirEntry = this.createDirEntry(fullPath, props);
            return sVNDirEntry;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession() {
        this.lock(true);
        try {
            if (this.myConnection != null) {
                this.myConnection.close();
                this.myConnection = null;
            }
        }
        finally {
            this.unlock();
        }
    }

    protected String doGetFullPath(String relativeOrRepositoryPath) throws SVNException {
        String fullPath;
        if (relativeOrRepositoryPath == null) {
            return this.doGetFullPath("/");
        }
        if (relativeOrRepositoryPath.length() > 0 && relativeOrRepositoryPath.charAt(0) == '/') {
            this.myConnection.fetchRepositoryRoot(this);
            fullPath = SVNPathUtil.append(this.myRepositoryRoot.getPath(), relativeOrRepositoryPath);
        } else {
            fullPath = SVNPathUtil.append(this.getLocation().getPath(), relativeOrRepositoryPath);
        }
        if (!fullPath.startsWith("/")) {
            fullPath = "/" + fullPath;
        }
        return fullPath;
    }

    protected String doGetRepositoryPath(String relativePath) throws SVNException {
        if (relativePath == null) {
            return "/";
        }
        if (relativePath.length() > 0 && relativePath.charAt(0) == '/') {
            return relativePath;
        }
        String fullPath = SVNPathUtil.append(this.getLocation().getPath(), relativePath);
        this.myConnection.fetchRepositoryRoot(this);
        String repositoryPath = fullPath.substring(this.myRepositoryRoot.getPath().length());
        if ("".equals(repositoryPath)) {
            return "/";
        }
        return repositoryPath;
    }

    private SVNDirEntry createDirEntry(String fullPath, DAVProperties child) throws SVNException {
        long size;
        String href = child.getURL();
        href = SVNEncodingUtil.uriDecode(href);
        String name = SVNPathUtil.tail(href);
        SVNNodeKind kind = SVNNodeKind.FILE;
        String revisionStr = child.getPropertyValue(DAVElement.VERSION_NAME);
        long lastRevision = Long.parseLong(revisionStr.toString());
        String sizeStr = child.getPropertyValue(DAVElement.GET_CONTENT_LENGTH);
        long l = size = sizeStr == null ? 0L : Long.parseLong(sizeStr);
        if (child.isCollection()) {
            kind = SVNNodeKind.DIR;
        }
        String author = child.getPropertyValue(DAVElement.CREATOR_DISPLAY_NAME);
        String dateStr = child.getPropertyValue(DAVElement.CREATION_DATE);
        Date date = dateStr != null ? SVNTimeUtil.parseDate(dateStr) : null;
        boolean hasProperties = false;
        for (DAVElement property : child.getProperties().keySet()) {
            if (!"http://subversion.tigris.org/xmlns/custom/".equals(property.getNamespace()) && !"http://subversion.tigris.org/xmlns/svn/".equals(property.getNamespace())) continue;
            hasProperties = true;
            break;
        }
        SVNURL url = this.getLocation().setPath(fullPath, true);
        return new SVNDirEntry(url, name, kind, size, hasProperties, lastRevision, date, author);
    }
}

