/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.io;

import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNConnectionListener;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNFileRevisionHandler;
import org.tmatesoft.svn.core.io.ISVNLocationEntryHandler;
import org.tmatesoft.svn.core.io.ISVNLockHandler;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.ISVNSession;
import org.tmatesoft.svn.core.io.ISVNTunnelProvider;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.core.io.SVNFileRevision;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;

public abstract class SVNRepository {
    protected String myRepositoryUUID;
    protected SVNURL myRepositoryRoot;
    protected SVNURL myLocation;
    private int myLockCount;
    private Thread myLocker;
    private ISVNAuthenticationManager myAuthManager;
    private ISVNSession myOptions;
    private ISVNTunnelProvider myTunnelProvider;
    private ISVNDebugLog myDebugLog;
    private ISVNCanceller myCanceller;
    private Collection myConnectionListeners;

    protected SVNRepository(SVNURL location, ISVNSession options) {
        this.myLocation = location;
        this.myOptions = options;
        this.myConnectionListeners = new HashSet();
    }

    public SVNURL getLocation() {
        return this.myLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocation(SVNURL url, boolean forceReconnect) throws SVNException {
        this.lock();
        try {
            if (url == null) {
                return;
            }
            if (!url.getProtocol().equals(this.myLocation.getProtocol())) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, "SVNRepository URL could not be changed from ''{0}'' to ''{1}''; create new SVNRepository instance instead", new Object[]{this.myLocation, url});
                SVNErrorManager.error(err);
            }
            if (forceReconnect) {
                this.closeSession();
                this.myRepositoryRoot = null;
                this.myRepositoryUUID = null;
            } else if (this.myRepositoryRoot == null) {
                if (!url.toString().startsWith(this.myLocation.toString() + "/") && !url.equals(this.getLocation())) {
                    this.closeSession();
                    this.myRepositoryRoot = null;
                    this.myRepositoryUUID = null;
                }
            } else if (!url.toString().startsWith(this.myRepositoryRoot.toString() + "/") && !this.myRepositoryRoot.equals(url)) {
                this.closeSession();
                this.myRepositoryRoot = null;
                this.myRepositoryUUID = null;
            }
            this.myLocation = url;
        }
        finally {
            this.unlock();
        }
    }

    public String getRepositoryUUID() {
        try {
            return this.getRepositoryUUID(false);
        }
        catch (SVNException sVNException) {
            return this.myRepositoryUUID;
        }
    }

    public String getRepositoryUUID(boolean forceConnection) throws SVNException {
        if (forceConnection && this.myRepositoryUUID == null) {
            this.testConnection();
        }
        return this.myRepositoryUUID;
    }

    public SVNURL getRepositoryRoot() {
        try {
            return this.getRepositoryRoot(false);
        }
        catch (SVNException sVNException) {
            return null;
        }
    }

    public SVNURL getRepositoryRoot(boolean forceConnection) throws SVNException {
        if (forceConnection && this.myRepositoryRoot == null) {
            this.testConnection();
        }
        return this.myRepositoryRoot;
    }

    public void setAuthenticationManager(ISVNAuthenticationManager authManager) {
        this.myAuthManager = authManager;
    }

    public ISVNAuthenticationManager getAuthenticationManager() {
        return this.myAuthManager;
    }

    public void setTunnelProvider(ISVNTunnelProvider tunnelProvider) {
        this.myTunnelProvider = tunnelProvider;
    }

    public ISVNTunnelProvider getTunnelProvider() {
        return this.myTunnelProvider;
    }

    public void setCanceller(ISVNCanceller canceller) {
        this.myCanceller = canceller;
    }

    public ISVNCanceller getCanceller() {
        return this.myCanceller == null ? ISVNCanceller.NULL : this.myCanceller;
    }

    protected void setRepositoryCredentials(String uuid, SVNURL rootURL) {
        if (uuid != null && rootURL != null) {
            this.myRepositoryUUID = uuid;
            this.myRepositoryRoot = rootURL;
        }
    }

    public abstract void testConnection() throws SVNException;

    public abstract long getLatestRevision() throws SVNException;

    public abstract long getDatedRevision(Date var1) throws SVNException;

    public abstract Map getRevisionProperties(long var1, Map var3) throws SVNException;

    public abstract void setRevisionPropertyValue(long var1, String var3, String var4) throws SVNException;

    public abstract String getRevisionPropertyValue(long var1, String var3) throws SVNException;

    public abstract SVNNodeKind checkPath(String var1, long var2) throws SVNException;

    public abstract long getFile(String var1, long var2, Map var4, OutputStream var5) throws SVNException;

    public abstract long getDir(String var1, long var2, Map var4, ISVNDirEntryHandler var5) throws SVNException;

    public abstract int getFileRevisions(String var1, long var2, long var4, ISVNFileRevisionHandler var6) throws SVNException;

    public long log(String[] targetPaths, long startRevision, long endRevision, boolean changedPath, boolean strictNode, ISVNLogEntryHandler handler) throws SVNException {
        return this.log(targetPaths, startRevision, endRevision, changedPath, strictNode, 0L, handler);
    }

    public abstract long log(String[] var1, long var2, long var4, boolean var6, boolean var7, long var8, ISVNLogEntryHandler var10) throws SVNException;

    public abstract int getLocations(String var1, long var2, long[] var4, ISVNLocationEntryHandler var5) throws SVNException;

    public Collection getFileRevisions(String path, Collection revisions, long sRevision, long eRevision) throws SVNException {
        final Collection result = revisions != null ? revisions : new LinkedList();
        ISVNFileRevisionHandler handler = new ISVNFileRevisionHandler(){

            public void openRevision(SVNFileRevision fileRevision) throws SVNException {
                result.add(fileRevision);
            }

            public void applyTextDelta(String path, String baseChecksum) throws SVNException {
            }

            public OutputStream textDeltaChunk(String token, SVNDiffWindow diffWindow) throws SVNException {
                return SVNFileUtil.DUMMY_OUT;
            }

            public void textDeltaEnd(String token) throws SVNException {
            }

            public void closeRevision(String token) throws SVNException {
            }
        };
        this.getFileRevisions(path, sRevision, eRevision, handler);
        return result;
    }

    public Collection getDir(String path, long revision, Map properties, Collection dirEntries) throws SVNException {
        final Collection result = dirEntries != null ? dirEntries : new LinkedList();
        ISVNDirEntryHandler handler = new ISVNDirEntryHandler(){

            public void handleDirEntry(SVNDirEntry dirEntry) {
                result.add(dirEntry);
            }
        };
        this.getDir(path, revision, properties, handler);
        return result;
    }

    public abstract SVNDirEntry getDir(String var1, long var2, boolean var4, Collection var5) throws SVNException;

    public Collection log(String[] targetPaths, Collection entries, long startRevision, long endRevision, boolean changedPath, boolean strictNode) throws SVNException {
        final Collection result = entries != null ? entries : new LinkedList();
        this.log(targetPaths, startRevision, endRevision, changedPath, strictNode, new ISVNLogEntryHandler(){

            public void handleLogEntry(SVNLogEntry logEntry) {
                result.add(logEntry);
            }
        });
        return result;
    }

    public Collection getLocations(String path, Collection entries, long pegRevision, long[] revisions) throws SVNException {
        final Collection result = entries != null ? entries : new LinkedList();
        this.getLocations(path, pegRevision, revisions, new ISVNLocationEntryHandler(){

            public void handleLocationEntry(SVNLocationEntry locationEntry) {
                result.add(locationEntry);
            }
        });
        return result;
    }

    public Map getLocations(String path, Map entries, long pegRevision, long[] revisions) throws SVNException {
        final Map result = entries != null ? entries : new HashMap();
        this.getLocations(path, pegRevision, revisions, new ISVNLocationEntryHandler(){

            public void handleLocationEntry(SVNLocationEntry locationEntry) {
                result.put(new Long(locationEntry.getRevision()), locationEntry);
            }
        });
        return result;
    }

    public abstract void diff(SVNURL var1, long var2, long var4, String var6, boolean var7, boolean var8, boolean var9, ISVNReporterBaton var10, ISVNEditor var11) throws SVNException;

    public abstract void diff(SVNURL var1, long var2, long var4, String var6, boolean var7, boolean var8, ISVNReporterBaton var9, ISVNEditor var10) throws SVNException;

    public abstract void diff(SVNURL var1, long var2, String var4, boolean var5, boolean var6, ISVNReporterBaton var7, ISVNEditor var8) throws SVNException;

    public abstract void update(long var1, String var3, boolean var4, ISVNReporterBaton var5, ISVNEditor var6) throws SVNException;

    public abstract void status(long var1, String var3, boolean var4, ISVNReporterBaton var5, ISVNEditor var6) throws SVNException;

    public abstract void update(SVNURL var1, long var2, String var4, boolean var5, ISVNReporterBaton var6, ISVNEditor var7) throws SVNException;

    public void checkout(long revision, String target, boolean recursive, ISVNEditor editor) throws SVNException {
        final long lastRev = revision >= 0L ? revision : this.getLatestRevision();
        SVNNodeKind nodeKind = this.checkPath("", revision);
        if (nodeKind == SVNNodeKind.FILE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' refers to a file, not a directory", this.getLocation());
            SVNErrorManager.error(err);
        } else if (nodeKind == SVNNodeKind.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' doesn't exist", this.getLocation());
            SVNErrorManager.error(err);
        }
        this.update(revision, target, recursive, new ISVNReporterBaton(){

            public void report(ISVNReporter reporter) throws SVNException {
                reporter.setPath("", null, lastRev, true);
                reporter.finishReport();
            }
        }, editor);
    }

    public abstract void replay(long var1, long var3, boolean var5, ISVNEditor var6) throws SVNException;

    public ISVNEditor getCommitEditor(String logMessage, ISVNWorkspaceMediator mediator) throws SVNException {
        return this.getCommitEditor(logMessage, null, false, mediator);
    }

    public abstract SVNDirEntry info(String var1, long var2) throws SVNException;

    public abstract ISVNEditor getCommitEditor(String var1, Map var2, boolean var3, ISVNWorkspaceMediator var4) throws SVNException;

    public abstract SVNLock getLock(String var1) throws SVNException;

    public abstract SVNLock[] getLocks(String var1) throws SVNException;

    public abstract void lock(Map var1, String var2, boolean var3, ISVNLockHandler var4) throws SVNException;

    public abstract void unlock(Map var1, boolean var2, ISVNLockHandler var3) throws SVNException;

    public abstract void closeSession();

    public ISVNSession getOptions() {
        if (this.myOptions == null) {
            this.myOptions = ISVNSession.DEFAULT;
        }
        return this.myOptions;
    }

    public void addConnectionListener(ISVNConnectionListener listener) {
        this.myConnectionListeners.add(listener);
    }

    public void removeConnectionListener(ISVNConnectionListener listener) {
        this.myConnectionListeners.remove(listener);
    }

    protected void fireConnectionOpened() {
        for (ISVNConnectionListener listener : this.myConnectionListeners) {
            listener.connectionOpened(this);
        }
    }

    protected void fireConnectionClosed() {
        for (ISVNConnectionListener listener : this.myConnectionListeners) {
            listener.connectionClosed(this);
        }
    }

    protected synchronized void lock() {
        this.lock(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void lock(boolean force) {
        try {
            SVNRepository sVNRepository = this;
            synchronized (sVNRepository) {
                if (Thread.currentThread() == this.myLocker) {
                    if (!force) {
                        this.getDebugLog().info(new Exception());
                        throw new Error("SVNRepository methods are not reenterable");
                    }
                    ++this.myLockCount;
                    return;
                }
                while (this.myLocker != null) {
                    this.wait();
                }
                this.myLocker = Thread.currentThread();
                ++this.myLockCount;
            }
        }
        catch (InterruptedException e) {
            throw new Error("Interrupted attempt to aquire write lock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void unlock() {
        SVNRepository sVNRepository = this;
        synchronized (sVNRepository) {
            if (--this.myLockCount <= 0) {
                this.myLockCount = 0;
                this.myLocker = null;
                this.notify();
            }
        }
    }

    protected static boolean isInvalidRevision(long revision) {
        return revision < 0L;
    }

    protected static boolean isValidRevision(long revision) {
        return revision >= 0L;
    }

    protected static Long getRevisionObject(long revision) {
        return SVNRepository.isValidRevision(revision) ? new Long(revision) : null;
    }

    protected static void assertValidRevision(long revision) throws SVNException {
        if (!SVNRepository.isValidRevision(revision)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Invalid revision number ''{0}''", new Long(revision));
            SVNErrorManager.error(err);
        }
    }

    public String getRepositoryPath(String relativePath) throws SVNException {
        if (relativePath == null) {
            return "/";
        }
        if (relativePath.length() > 0 && relativePath.charAt(0) == '/') {
            return relativePath;
        }
        String fullPath = SVNPathUtil.append(this.getLocation().getPath(), relativePath);
        String repositoryPath = fullPath.substring(this.getRepositoryRoot(true).getPath().length());
        if ("".equals(repositoryPath)) {
            return "/";
        }
        return repositoryPath;
    }

    public String getFullPath(String relativeOrRepositoryPath) throws SVNException {
        if (relativeOrRepositoryPath == null) {
            return this.getFullPath("/");
        }
        String fullPath = relativeOrRepositoryPath.length() > 0 && relativeOrRepositoryPath.charAt(0) == '/' ? SVNPathUtil.append(this.getRepositoryRoot(true).getPath(), relativeOrRepositoryPath) : SVNPathUtil.append(this.getLocation().getPath(), relativeOrRepositoryPath);
        if (!fullPath.startsWith("/")) {
            fullPath = "/" + fullPath;
        }
        return fullPath;
    }

    public void setDebugLog(ISVNDebugLog log) {
        this.myDebugLog = log;
    }

    public ISVNDebugLog getDebugLog() {
        if (this.myDebugLog == null) {
            return SVNDebugLog.getDefaultLog();
        }
        return this.myDebugLog;
    }
}

