/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.core.wc.SVNCommitItem;

public class SVNCommitMediator
implements ISVNWorkspaceMediator {
    private Collection myTmpFiles = new ArrayList();
    private Map myWCPropsMap = new HashMap();
    private Map myCommitItems;

    public SVNCommitMediator(Map commitItems) {
        this.myCommitItems = commitItems;
    }

    public Map getWCProperties(SVNCommitItem item) {
        return (Map)this.myWCPropsMap.get(item);
    }

    public Collection getTmpFiles() {
        return this.myTmpFiles;
    }

    public String getWorkspaceProperty(String path, String name) throws SVNException {
        String target;
        SVNAdminArea dir;
        SVNCommitItem item = (SVNCommitItem)this.myCommitItems.get(path);
        if (item == null) {
            return null;
        }
        SVNWCAccess wcAccess = item.getWCAccess();
        if (item.getKind() == SVNNodeKind.DIR) {
            dir = wcAccess.retrieve(item.getFile());
            target = "";
        } else {
            dir = wcAccess.retrieve(item.getFile().getParentFile());
            target = SVNPathUtil.tail(item.getPath());
        }
        SVNVersionedProperties wcProps = dir.getWCProperties(target);
        return wcProps.getPropertyValue(name);
    }

    public void setWorkspaceProperty(String path, String name, String value) throws SVNException {
        if (name == null) {
            return;
        }
        SVNCommitItem item = (SVNCommitItem)this.myCommitItems.get(path);
        if (!this.myWCPropsMap.containsKey(item)) {
            this.myWCPropsMap.put(item, new HashMap());
        }
        ((Map)this.myWCPropsMap.get(item)).put(name, value);
    }
}

