/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.xml.sax.Attributes;

public class DAVProppatchHandler
extends BasicDAVHandler {
    public static StringBuffer generatePropertyRequest(StringBuffer buffer, String name, String value) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(name, value);
        return DAVProppatchHandler.generatePropertyRequest(buffer, map);
    }

    public static StringBuffer generatePropertyRequest(StringBuffer buffer, Map properties) {
        String value;
        buffer = buffer == null ? new StringBuffer() : buffer;
        buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
        buffer.append("<D:propertyupdate xmlns:D=\"DAV:\" xmlns:V=\"");
        buffer.append("http://subversion.tigris.org/xmlns/dav/");
        buffer.append("\" xmlns:C=\"");
        buffer.append("http://subversion.tigris.org/xmlns/custom/");
        buffer.append("\" xmlns:S=\"");
        buffer.append("http://subversion.tigris.org/xmlns/svn/");
        buffer.append("\" >\n");
        if (DAVProppatchHandler.hasNotNullValues(properties)) {
            buffer.append("<D:set><D:prop>\n");
            for (String name : properties.keySet()) {
                value = (String)properties.get(name);
                if (value == null) continue;
                buffer = DAVProppatchHandler.appendProperty(buffer, name, value);
            }
            buffer.append("\n</D:prop></D:set>");
        }
        if (DAVProppatchHandler.hasNullValues(properties)) {
            buffer.append("<D:remove><D:prop>\n");
            for (String name : properties.keySet()) {
                value = (String)properties.get(name);
                if (value != null) continue;
                buffer = DAVProppatchHandler.appendProperty(buffer, name, value);
            }
            buffer.append("\n</D:prop></D:remove>");
        }
        buffer.append("\n</D:propertyupdate>");
        return buffer;
    }

    private static StringBuffer appendProperty(StringBuffer buffer, String name, String value) {
        buffer.append("<");
        int index = buffer.length();
        if (name.startsWith("svn:")) {
            buffer.append("S:");
            buffer.append(name.substring("svn:".length()));
        } else {
            buffer.append("C:");
            buffer.append(name);
        }
        int index2 = buffer.length();
        if (value == null) {
            return buffer.append(" />");
        }
        if (SVNEncodingUtil.isXMLSafe(value)) {
            value = SVNEncodingUtil.xmlEncodeCDATA(value);
        } else {
            value = SVNBase64.byteArrayToBase64(value.getBytes());
            buffer.append(" V:encoding=\"base64\"");
        }
        buffer.append(">");
        buffer.append(value);
        buffer.append("</");
        buffer.append(buffer.substring(index, index2));
        return buffer.append(">");
    }

    protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) throws SVNException {
    }

    protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) throws SVNException {
    }

    private static boolean hasNullValues(Map map) {
        if (map.isEmpty()) {
            return false;
        }
        return map.containsValue(null);
    }

    private static boolean hasNotNullValues(Map map) {
        if (map.isEmpty()) {
            return false;
        }
        if (!DAVProppatchHandler.hasNullValues(map)) {
            return true;
        }
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            return true;
        }
        return false;
    }
}

