/*
 * Decompiled with CFR 0.152.
 */
package it.could.webdav.replication;

import it.could.util.location.Location;
import it.could.webdav.DAVLogger;
import it.could.webdav.DAVRepository;
import it.could.webdav.DAVServlet;
import it.could.webdav.replication.DAVReplica;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;

public class DAVReplicator
extends HttpServlet {
    private final List replicas = new ArrayList();

    public void init(ServletConfig config) throws ServletException {
        DAVRepository repository;
        super.init(config);
        boolean debug = "true".equals(config.getInitParameter("debugEnabled"));
        DAVLogger logger = new DAVLogger(config, debug);
        String repositoryName = config.getInitParameter("repository");
        if (repositoryName == null) {
            throw new ServletException("Parameter \"rootPath\" not specified");
        }
        try {
            String key = DAVServlet.getRepositoryKey(repositoryName);
            ServletContext context = config.getServletContext();
            repository = (DAVRepository)context.getAttribute(key);
            if (repository == null) {
                throw new ServletException("Unable to access repository from servlet \"" + repository + "\"");
            }
        }
        catch (ClassCastException exception) {
            String message = "Class cast exception accessing repository";
            throw new ServletException("Class cast exception accessing repository", (Throwable)exception);
        }
        String replicas = config.getInitParameter("replicas");
        if (replicas == null) {
            throw new ServletException("Parameter \"replicas\" not specified");
        }
        try {
            StringTokenizer tokenizer = new StringTokenizer(replicas);
            while (tokenizer.hasMoreTokens()) {
                Location location = Location.parse(tokenizer.nextToken());
                DAVReplica replica = new DAVReplica(repository, location, logger);
                logger.log("Added repository replica to \"" + location + "\"");
                repository.addListener(replica);
                this.replicas.add(replica);
                replica.synchronize();
            }
        }
        catch (IOException exception) {
            throw new ServletException("Error creating replica", (Throwable)exception);
        }
        if (this.replicas.size() != 0) {
            return;
        }
        throw new ServletException("No replicas specified for repository");
    }

    public void destroy() {
        Iterator iter = this.replicas.iterator();
        while (iter.hasNext()) {
            ((DAVReplica)iter.next()).interrupt();
        }
    }
}

