/*
 * Decompiled with CFR 0.152.
 */
package it.could.webdav.methods;

import it.could.webdav.DAVException;
import it.could.webdav.DAVMethod;
import it.could.webdav.DAVResource;
import it.could.webdav.DAVTransaction;
import it.could.webdav.DAVUtilities;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;

public class PROPFIND
implements DAVMethod {
    public void process(DAVTransaction transaction, DAVResource resource) throws IOException {
        if (resource.isNull()) {
            throw new DAVException(404, "Not found", resource);
        }
        int depth = transaction.getDepth();
        if (depth > 1) {
            new DAVException(403, "Invalid depth");
        }
        transaction.setStatus(207);
        transaction.setContentType("text/xml; charset=\"UTF-8\"");
        PrintWriter out = transaction.write("UTF-8");
        out.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<D:multistatus xmlns:D=\"DAV:\">");
        this.process(transaction, out, resource);
        if (resource.isCollection() && depth > 0) {
            Iterator children = resource.getChildren();
            while (children.hasNext()) {
                DAVResource child = (DAVResource)children.next();
                this.process(transaction, out, child);
            }
        }
        out.println("</D:multistatus>");
        out.flush();
    }

    private void process(DAVTransaction txn, PrintWriter out, DAVResource res) {
        out.println(" <D:response>");
        out.println("  <D:href>" + txn.lookup(res).getPath() + "</D:href>");
        out.println("  <D:propstat>");
        out.println("   <D:prop>");
        if (res.isCollection()) {
            this.process(out, "resourcetype", "<D:collection/>");
        }
        this.process(out, "getcontenttype", res.getContentType());
        this.process(out, "getetag", res.getEntityTag());
        String date = DAVUtilities.formatIsoDate(res.getCreationDate());
        this.process(out, "creationdate", date);
        String lmod = DAVUtilities.formatHttpDate(res.getLastModified());
        this.process(out, "getlastmodified", lmod);
        String clen = DAVUtilities.formatNumber(res.getContentLength());
        this.process(out, "getcontentlength", clen);
        out.println("   </D:prop>");
        out.println("   <D:status>HTTP/1.1 200 OK</D:status>");
        out.println("  </D:propstat>");
        out.println(" </D:response>");
    }

    private void process(PrintWriter out, String name, String value) {
        if (value == null) {
            return;
        }
        out.print("    <D:");
        out.print(name);
        out.print(">");
        out.print(value);
        out.print("</D:");
        out.print(name);
        out.println(">");
    }
}

