/*
 * Decompiled with CFR 0.152.
 */
package it.could.webdav.methods;

import it.could.webdav.DAVException;
import it.could.webdav.DAVMethod;
import it.could.webdav.DAVNotModified;
import it.could.webdav.DAVResource;
import it.could.webdav.DAVTransaction;
import it.could.webdav.DAVUtilities;
import java.io.IOException;
import java.util.Date;

public class HEAD
implements DAVMethod {
    public void process(DAVTransaction transaction, DAVResource resource) throws IOException {
        if (resource.isNull()) {
            throw new DAVException(404, "Not found", resource);
        }
        Date ifmod = transaction.getIfModifiedSince();
        Date lsmod = resource.getLastModified();
        if (resource.isResource() && ifmod != null && lsmod != null && !ifmod.before(lsmod = new Date(lsmod.getTime() / 1000L * 1000L))) {
            throw new DAVNotModified(resource);
        }
        String ctyp = resource.getContentType();
        String etag = resource.getEntityTag();
        String lmod = DAVUtilities.formatHttpDate(resource.getLastModified());
        String clen = DAVUtilities.formatNumber(resource.getContentLength());
        if (resource.isCollection()) {
            transaction.setContentType("text/html ;charset=\"UTF-8\"");
        } else if (ctyp != null) {
            transaction.setContentType(ctyp);
        }
        if (etag != null) {
            transaction.setHeader("ETag", etag);
        }
        if (lmod != null) {
            transaction.setHeader("Last-Modified", lmod);
        }
        if (clen != null) {
            transaction.setHeader("Content-Length", clen);
        }
    }
}

