/*
 * Decompiled with CFR 0.152.
 */
package it.could.webdav.methods;

import it.could.webdav.DAVException;
import it.could.webdav.DAVMethod;
import it.could.webdav.DAVMultiStatus;
import it.could.webdav.DAVResource;
import it.could.webdav.DAVTransaction;
import java.io.IOException;
import java.net.URI;

public class COPY
implements DAVMethod {
    public void process(DAVTransaction transaction, DAVResource resource) throws IOException {
        URI target = transaction.getDestination();
        if (target == null) {
            throw new DAVException(412, "No destination");
        }
        DAVResource dest = resource.getRepository().getResource(target);
        int depth = transaction.getDepth();
        boolean recursive = false;
        if (depth == 0) {
            recursive = false;
        } else if (depth == Integer.MAX_VALUE) {
            recursive = true;
        } else {
            throw new DAVException(412, "Invalid Depth specified");
        }
        try {
            resource.copy(dest, transaction.getOverwrite(), recursive);
            transaction.setStatus(204);
        }
        catch (DAVMultiStatus multistatus) {
            multistatus.write(transaction);
        }
    }
}

