/*
 * Decompiled with CFR 0.152.
 */
package it.could.webdav;

import it.could.webdav.DAVException;
import it.could.webdav.DAVOutputStream;
import it.could.webdav.DAVRepository;
import it.could.webdav.DAVResource;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLRepository
extends DAVRepository {
    public XMLRepository(File root) throws IOException {
        super(root);
    }

    public DAVResource getResource(URI uri) throws IOException {
        return new XMLResource(this, super.getResource(uri));
    }

    private static final class XMLOutputStream
    extends DAVOutputStream {
        protected XMLOutputStream(XMLResource resource) {
            super(resource);
        }

        protected void rename(File temporary, File original) throws IOException {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setValidating(false);
                SAXParser parser = factory.newSAXParser();
                parser.parse(temporary, new DefaultHandler());
                super.rename(temporary, original);
            }
            catch (ParserConfigurationException exception) {
                throw new DAVException(500, "JAXP parser error", exception);
            }
            catch (SAXException exception) {
                throw new DAVException(415, "Error parsing data", exception);
            }
        }
    }

    private static final class XMLResource
    extends DAVResource {
        public XMLResource(XMLRepository repository, DAVResource resource) {
            super(repository, resource.getFile());
        }

        public String getContentType() {
            if (this.isResource()) {
                return "text/xml";
            }
            return super.getContentType();
        }

        public DAVOutputStream write() {
            return new XMLOutputStream(this);
        }
    }
}

